﻿//**************************************************************************************************
// :: AnonStringTransaction - Anonmapping String Transaction ::
//                                                  ver 2.00
//--------------------------------------------------------------------------------------------------
// XML Tag : "string-action" =
//                             "CMD.(+.CMD)^*"
// where CMD =
//             REPLACE(left, right, what, byFixed, character, byRandom, by) - returning void
//             GET(left, right) - returning string lenght (r-l) from string buffer
//             GENERATE(byFixed, character, byRandom, by):[newlength]
//             "fixed text"
//
// left = x         - means first position
//        [number]
//
// right = [number]
//         y        - means last position
//
// what = abc -     means standard small alphabet
//        abc! -    means with comma, full stop, question mark and so on
//        abc!! -   means also with blank spaces
//        ABC -     means standard big alphabet
//        ABC!
//        ABC!!
//        Abc
//        Abc!
//        Abc!!
//        123 -     means numbers only
//        123!
//        123!!
//        abc123
//        ABC123
//        ABC123!
//        ABC123!
//        Abc123 =  default
//        Abc123!
//        Abc123!!
//
// by = [what]
//      abc123 = default
//
//**************************************************************************************************
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace PacMap.Anonymize.Transactions
{
    /// <summary>
    /// Anonmapping String Transaction Class
    /// </summary>
    public class AnonStringTransaction : AnonTransaction
    {

        /// <summary>
        /// Construct Empty Anonmapping String Transaction
        /// </summary>
        public AnonStringTransaction()
            : base()
        {
            Initialize();
        }

        /// <summary>
        /// Construct User Anonmapping String Transaction
        /// </summary>
        /// <param name="phrase"></param>
        public AnonStringTransaction(string phrase) : base(phrase)
        {
            Initialize();

            if (phrase == "none")
            {
                isCorrect = true;
                isEmpty = true;
                return;
            }

            bool onlyFirstCmd = false;
            isEmpty = false;
            string[] cmdsstring = phrase.Split(new char[] { '+' }, StringSplitOptions.RemoveEmptyEntries);
            if (cmdsstring.Count() == 1)
                onlyFirstCmd = true;


            foreach (var item in cmdsstring)
            {

                //
                // CONST String
                //
                #region Const
                if (item.Length > 2)
                {
                    string left = item.Substring(0, 1);
                    string right = item.Substring(item.Length - 1, 1);
                    string replaceText = item.Substring(1, item.Length - 2);
                    if (((left == "'") && (right == "'")) ||
                        ((left == "\"") && (right == "\"")))
                    {
                        StringAction action = new StringAction(() =>
                            {
                                return StringConst(replaceText);
                            });
                        commands.Add(action);
                    }
                }
                #endregion

                //
                // REPLACE Command
                //
                #region REPLACE
                if (item.Length >= 9)
                {
                    string that = item.Substring(0, 7);
                    string left = item.Substring(7, 1);
                    string right = item.Substring(item.Length - 1, 1);
                    string contentText = item.Substring(8, item.Length - 9);
                    bool hasSemiValue = false;
                    string newLength = "";
                    #region Test For Value behind ":"
                    // Test for SemiValue
                    {
                        string[] seps = item.Split(new char[]{':'}, StringSplitOptions.RemoveEmptyEntries);
                        if (seps.Count() == 2)
                        {
                            if (seps[0].Length >= 9)
                            {
                                that = seps[0].Substring(0, 7);
                                left = seps[0].Substring(7, 1);
                                right = seps[0].Substring(seps[0].Length - 1, 1);
                                contentText = item.Substring(8, seps[0].Length - 9);

                                int newValue;
                                bool isOk = int.TryParse(seps[1], out newValue);
                                if (isOk)
                                {
                                    hasSemiValue = true;
                                    newLength = seps[1];
                                }
                            }
                        }
                    }
                    #endregion
                    if ((that == "REPLACE") && (left == "(") && (right == ")"))
                    {
                        string[] groups = contentText.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);


                        // Static variations:
                        //
                        // REPLACE(left, right, char)
                        // REPLACE(left, right, what, char)
                        // REPLACE(what, char)
                        // REPLACE(char)
                        // REPLACE(char):[newlength]
                        

                        // == REPLACE(left, right, char) ==
                        if (groups.Count() == 3)
                        {
                            int l;
                            int r;
                            bool lOk = int.TryParse(groups[0], out l);
                            bool rOk = int.TryParse(groups[1], out r);
                            if (((lOk) || (groups[0] == "x")) ||
                                ((rOk) || (groups[1] == "x") || (groups[1] == "y")) &&
                                (groups[2].Length == 1))
                            {
                                char character = groups[2][0];
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace(groups[0], groups[1], "", true, character, false, "", false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }

                        // == REPLACE(left, right, what, char) ==
                        if (groups.Count() == 4)
                        {
                            int l;
                            int r;
                            bool lOk = int.TryParse(groups[0], out l);
                            bool rOk = int.TryParse(groups[1], out r);
                            if (((lOk) || (groups[0] == "x")) ||
                                ((rOk) || (groups[1] == "x") || (groups[1] == "y")) &&
                                (groups[3].Length == 1) &&
                                (IsAbc123Command(groups[2])))
                            {
                                char character = groups[2][0];
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace(groups[0], groups[1], groups[2], true, character, false, "", false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }



                        // == REPLACE(what, char) ==
                        if (groups.Count() == 2)
                        {
                            if ((IsAbc123Command(groups[0])) && (groups[1].Length == 3))
                            {
                                char character = groups[1][0];
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace("x", "y", groups[0], true, character, false, "", false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }



                        // == REPLACE(char) ==
                        if ((groups.Count() == 1) && (!hasSemiValue))
                        {
                            if (groups[0].Length == 1)
                            {
                                char character = groups[0][0];
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace("x", "y", "", true, character, false, "", false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }




                        // == REPLACE(char):[newlength] ==
                        if ((groups.Count() == 1) && (hasSemiValue) && (onlyFirstCmd))
                        {
                            if (groups[0].Length == 1)
                            {
                                char character = groups[0][0];
                                int value;
                                int.TryParse(newLength, out value);
                                StringAction action = new StringAction(() =>
                                    {
                                        return Replace("x", "y", "", true, character, false, "", true, value);
                                    });
                                commands.Add(action);
                            }
                        }


                        


                        /**********************/



                        // Random variations:
                        //
                        // REPLACE()
                        // REPLACE():[newlength]
                        // REPLACE(by)
                        // REPLACE(by):[newlength]
                        // REPLACE(what, by)
                        // REPLACE(left, right)
                        // REPLACE(left, right, by)
                        // REPLACE(left, right, what, by)


                        // == REPLACE() ==
                        if ((contentText == "") && (!hasSemiValue))
                        {
                            StringAction action = new StringAction(() =>
                                {
                                    Replace("x", "y", "", false, ' ', true, "", false, 0);
                                    if (!onlyFirstCmd)
                                        return "";
                                    else
                                        return buffer;
                                });
                            commands.Add(action);
                        }


                        // == REPLACE():[newlength] ==
                        if ((contentText == "") && (hasSemiValue) && (onlyFirstCmd))
                        {
                            int value;
                            int.TryParse(newLength, out value);
                            StringAction action = new StringAction(() =>
                                {
                                    return Replace("x", "y", "", false, ' ', true, "", true, value);
                                });
                            commands.Add(action);
                        }

                        // == REPLACE(by) ==
                        if ((groups.Count() == 1) && (!hasSemiValue))
                        {
                            if (IsAbc123Command(groups[0]))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace("x", "y", "", false, ' ', true, groups[0], false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }


                        // == REPLACE(by):[newlength] ==
                        if ((groups.Count() == 1) && (hasSemiValue) && (onlyFirstCmd))
                        {
                            if (IsAbc123Command(groups[0]))
                            {
                                int value;
                                int.TryParse(newLength, out value);
                                StringAction action = new StringAction(() =>
                                    {
                                        return Replace("x", "y", "", false, ' ', true, groups[0], true, value);
                                    });
                                commands.Add(action);
                            }
                        }


                        // == REPLACE(what, by) ==
                        if (groups.Count() == 2)
                        {
                            if ((IsAbc123Command(groups[0])) && (IsAbc123Command(groups[1])))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace("x", "y", groups[0], false, ' ', true, groups[1], false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }



                        // == REPLACE(left, right)
                        if (groups.Count() == 2)
                        {
                            int l;
                            int r;
                            bool lOk = int.TryParse(groups[0], out l);
                            bool rOk = int.TryParse(groups[1], out r);
                            if (((lOk) || (groups[0] == "x")) &&
                                ((rOk) || (groups[1] == "x") || (groups[1] == "y")))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace(groups[0], groups[1], "", false, ' ', true, "", false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }


                        // == REPLACE(left, right, by) ==
                        if (groups.Count() == 3)
                        {
                            int l;
                            int r;
                            bool lOk = int.TryParse(groups[0], out l);
                            bool rOk = int.TryParse(groups[1], out r);
                            if (((lOk) || (groups[0] == "x")) &&
                                ((rOk) || (groups[1] == "x") || (groups[1] == "y")) &&
                                (IsAbc123Command(groups[2])))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace(groups[0], groups[1], "", false, ' ', true, groups[2], false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }



                        // == REPLACE(left, right, what, by)
                        if (groups.Count() == 4)
                        {
                            int l;
                            int r;
                            bool lOk = int.TryParse(groups[0], out l);
                            bool rOk = int.TryParse(groups[1], out r);
                            if (((lOk) || (groups[0] == "x")) &&
                                ((rOk) || (groups[1] == "x") || (groups[1] == "y")) &&
                                (IsAbc123Command(groups[2])) &&
                                (IsAbc123Command(groups[3])))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        Replace(groups[0], groups[1], groups[2], false, ' ', true, groups[3], false, 0);
                                        if (!onlyFirstCmd)
                                            return "";
                                        else
                                            return buffer;
                                    });
                                commands.Add(action);
                            }
                        }

                    }
                }
                #endregion

                //
                // GET Command
                // 
                #region GET
                if (item.Length >= 5)
                {
                    string that = item.Substring(0, 3);
                    string left = item.Substring(3, 1);
                    string right = item.Substring(item.Length - 1, 1);
                    string contentText = item.Substring(4, item.Length - 5);
                    if ((that == "GET") && (left == "(") && (right == ")"))
                    {
                        // Variations:
                        //
                        // GET()
                        // GET(left, right)
                        string[] groups = contentText.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);


                        // == GET() ==
                        if (contentText == "")
                        {
                            StringAction action = new StringAction(() =>
                                {
                                    return Get("x", "y");
                                });
                            commands.Add(action);
                        }



                        // == GET(left, right) ==
                        if (groups.Count() == 2)
                        {
                            int l;
                            int r;
                            bool lOk = int.TryParse(groups[0], out l);
                            bool rOk = int.TryParse(groups[1], out r);
                            if (((lOk) || (groups[0] == "x")) &&
                                ((rOk) || (groups[1] == "x") || (groups[1] == "y")))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        return Get(groups[0], groups[1]);
                                    });
                                commands.Add(action);
                            }
                        }

                    }

                }
                #endregion


                //
                // GENERATE Command
                //
                #region GENERATE
                if (item.Length >= 10)
                {
                    string that = item.Substring(0, 8);
                    string left = item.Substring(8, 1);
                    string right = item.Substring(item.Length - 1, 1);
                    string contentText = item.Substring(9, item.Length - 10);
                    bool hasSemiValue = false;
                    string newLength = "";
                    #region Test For Value behind ":"
                    // Test for SemiValue
                    {
                        string[] seps = item.Split(new char[] { ':' }, StringSplitOptions.RemoveEmptyEntries);
                        if (seps.Count() == 2)
                        {
                            if (seps[0].Length >= 10)
                            {
                                that = seps[0].Substring(0, 8);
                                left = seps[0].Substring(8, 1);
                                right = seps[0].Substring(seps[0].Length - 1, 1);
                                contentText = item.Substring(9, seps[0].Length - 10);

                                int newValue;
                                bool isOk = int.TryParse(seps[1], out newValue);
                                if (isOk)
                                {
                                    hasSemiValue = true;
                                    newLength = seps[1];
                                }
                            }
                        }
                    }
                    #endregion
                    if ((that == "GENERATE") && (left == "(") && (right == ")"))
                    {
                        string[] groups = contentText.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);

                        // Variations:
                        //
                        // GENERATE():[newlength]
                        // GENERATE(char):[newlength]
                        // GENERATE(by):[newlength]


                        // == GENERATE():[newlength]
                        if ((contentText == "") && (hasSemiValue))
                        {
                            int value;
                            int.TryParse(newLength, out value);
                            StringAction action = new StringAction(() =>
                                {
                                    return Generate(false, ' ', true, "", value);
                                });
                            commands.Add(action);
                        }

                        if ((groups.Count() == 1) && (hasSemiValue))
                        {
                            int value;
                            int.TryParse(newLength, out value);

                            // == GENERATE(by):[newlength] ==
                            if (IsAbc123Command(groups[0]))
                            {
                                StringAction action = new StringAction(() =>
                                    {
                                        return Generate(false, ' ', true, groups[0], value);
                                    });
                                commands.Add(action);
                            }


                            // == GENERATE(char):[newlength] ==
                            else if (groups[0].Length == 1)
                            {
                                char character = groups[0][0];
                                StringAction action = new StringAction(() =>
                                    {
                                        return Generate(true, character, false, "", value);
                                    });
                                commands.Add(action);
                            }
                        }


                    }

                }
                #endregion

            }


            if (cmdsstring.Count() == commands.Count)
                isCorrect = true;

        }





        


        /**********************************************************************************************/
        // :: DATA FIELDs ::
        
        //delegate string ReplaceDelegate(string left, string right, string what, bool byFixed, char character, bool byRandom, string by, bool isNewLength, int newLength);
        //delegate string GetDelegate(string left, string right);
        //delegate string GenerateDelegate(bool byFixed, char character, bool byRandom, string by, int newLength);
        //delegate string StringConstDelegate(string constantString);
        delegate string StringAction();
        IList<StringAction> commands = new List<StringAction>();
        private string buffer = "";
        [Flags]
        private enum AbsEnum
        {
            abc = 0x01,
            ABC = 0x02,
            _123 = 0x04,
            dotted = 0x08,
            spaced = 0x10,
        };
        private readonly IDictionary<string, AbsEnum> AbsDir = new Dictionary<string, AbsEnum>()
        {
            {"abc", AbsEnum.abc},
            {"abc!", AbsEnum.abc | AbsEnum.dotted},
            {"abc!!", AbsEnum.abc | AbsEnum.dotted | AbsEnum.spaced},
            {"Abc", AbsEnum.abc | AbsEnum.ABC},
            {"Abc!", AbsEnum.abc | AbsEnum.ABC | AbsEnum.dotted},
            {"Abc!!", AbsEnum.abc | AbsEnum.ABC | AbsEnum.dotted | AbsEnum.spaced},
            {"ABC", AbsEnum.ABC},
            {"ABC!", AbsEnum.ABC | AbsEnum.dotted},
            {"ABC!!", AbsEnum.ABC | AbsEnum.dotted | AbsEnum.spaced},
            {"123", AbsEnum._123},
            {"123!", AbsEnum._123 | AbsEnum.dotted},
            {"123!!", AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced},
            {"abc123", AbsEnum.abc | AbsEnum._123},
            {"abc123!", AbsEnum.abc | AbsEnum._123 | AbsEnum.dotted},
            {"abc123!!", AbsEnum.abc | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced},
            {"ABC123", AbsEnum.ABC | AbsEnum._123},
            {"ABC123!", AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted},
            {"ABC123!!", AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced},
            {"Abc123", AbsEnum.abc | AbsEnum.ABC | AbsEnum._123},
            {"Abc123!", AbsEnum.abc | AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted},
            {"Abc123!!", AbsEnum.abc | AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced},
            {"", AbsEnum.abc | AbsEnum.ABC | AbsEnum._123},
            {"default", AbsEnum.abc | AbsEnum._123},
            {"full", AbsEnum.abc | AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced},
        };

        private char[] only_abc = null;
        private char[] only_ABC = null;
        private char[] only_123 = null;
        private char[] only_dotted = new char[] { '.', ':', '/', '+', '-', '*', '%', ',', ';', '-', '=' };
        private char[] only_spaced = new char[] { ' ' };



        /**********************************************************************************************/
        // :: PROPERTIEs ::
        



        /**********************************************************************************************/
        // :: FUNCTIONs ::
        /// <summary>
        /// Full Initializing Class
        /// </summary>
        private void Initialize()
        {
            IList<char> only_123_list = new List<char>();
            for (int i = 48; i <= 57; i++)
            {
                only_123_list.Add((char)i);
            }
            only_123 = only_123_list.ToArray();

            IList<char> only_abc_list = new List<char>();
            for (int i = 97; i <= 122; i++)
            {
                only_abc_list.Add((char)i);
            }
            only_abc = only_abc_list.ToArray();

            IList<char> only_ABC_list = new List<char>();
            for (int i = 65; i <= 90; i++)
            {
                only_ABC_list.Add((char)i);
            }
            only_ABC = only_ABC_list.ToArray();
            
        }

        /// <summary>
        /// Prepare Special Buffer Collection for Randomizator
        /// </summary>
        /// <param name="bywhat">what enum replacing content</param>
        /// <returns>buffer collection</returns>
        private IList<char> PrepareRandomCollection(AbsEnum bywhat)
        {
            IList<char> randomCollection = new List<char>();

            switch (bywhat)
            {
                //
                // abc
                //
                case AbsEnum.abc:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;




                //
                // ABC
                //
                case AbsEnum.ABC:
                    {
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                    }
                    break;
                case AbsEnum.ABC | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum.ABC | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;



                //
                // Abc
                //
                case AbsEnum.abc | AbsEnum.ABC:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum.ABC | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum.ABC | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;





                //
                // 123
                //
                case AbsEnum._123:
                    {
                        randomCollection = randomCollection.Concat(only_123).ToList();
                    }
                    break;
                case AbsEnum._123 | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;



                //
                // abc123
                //
                case AbsEnum.abc | AbsEnum._123:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum._123 | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;





                //
                // ABC123
                //
                case AbsEnum.ABC | AbsEnum._123:
                    {
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                    }
                    break;
                case AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;





                //
                // Abc123
                //
                case AbsEnum.abc | AbsEnum.ABC | AbsEnum._123:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                    }
                    break;
                case AbsEnum.abc | AbsEnum.ABC | AbsEnum._123 | AbsEnum.dotted | AbsEnum.spaced:
                    {
                        randomCollection = randomCollection.Concat(only_abc).ToList();
                        randomCollection = randomCollection.Concat(only_ABC).ToList();
                        randomCollection = randomCollection.Concat(only_123).ToList();
                        randomCollection = randomCollection.Concat(only_dotted).ToList();
                        randomCollection = randomCollection.Concat(only_spaced).ToList();
                    }
                    break;
            }

            return randomCollection;
        }

        /// <summary>
        /// Is input string "what" or "by" command
        /// </summary>
        /// <param name="phrase">input string</param>
        /// <returns>TRUE if success</returns>
        private bool IsAbc123Command(string phrase)
        {
            bool bresult = false;
            bresult = (phrase.ToLower() == "abc") || (phrase.ToLower() == "abc!") || (phrase.ToLower() == "abc!!") ||
                      (phrase == "123") || (phrase == "123!") || (phrase == "123!!") ||
                      (phrase.ToLower() == "abc123") || (phrase.ToLower() == "default") || (phrase == "") || (phrase.ToLower() == "abc123!") || (phrase.ToLower() == "abc123!!") || (phrase.ToLower() == "full");
            return bresult;
        }

        /// <summary>
        /// Convert string Codename to What Enum Replacing Content
        /// </summary>
        /// <param name="input">string codename</param>
        /// <returns>what enum replacing content</returns>
        private AbsEnum ToAbc(string input)
        {
            AbsEnum result = AbsEnum.abc | AbsEnum._123 | AbsEnum.dotted;
            if (AbsDir.ContainsKey(input))
            {
                result = AbsDir[input];
            }
            return result;
        }

        /// <summary>
        /// Convert
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        private string ToString(AbsEnum input)
        {
            string result = "";
            result = AbsDir.Where(item => item.Value == input).First().Key;
            return result;
        }

        /// <summary>
        /// Replace any string in "buffer".
        /// </summary>
        /// <param name="left">left position where to start</param>
        /// <param name="right">right position where to end</param>
        /// <param name="what">what to be replaced ("abc", "abc!", ...)</param>
        /// <param name="byFixed">replacing with fixed character</param>
        /// <param name="character">single fixed character pattern</param>
        /// <param name="byRandom">replacing with random string</param>
        /// <param name="by">by what to replace ("abc", "abc!", ...)</param>
        /// <param name="isNewLength">is new length</param>
        /// <param name="newLength">new length value</param>
        /// <returns>if new length, than result, otherwise ""</returns>
        private string Replace(string left, string right, string what, bool byFixed, char character, bool byRandom, string by, bool isNewLength, int newLength)
        {
            int index = 0;
            int howmany = 0;
            #region index, howmany = left - 1, right - left + 1
            {
                int l;
                int r;
                if (int.TryParse(left, out l))
                {
                    if ((l >= 1) && (l <= buffer.Length))
                    {
                    }
                    else
                    {
                        l = 1;
                    }
                }
                else
                    l = 1;

                if (int.TryParse(right, out r))
                {
                    if ((r >= 1) && (r <= buffer.Length))
                    {
                    }
                    else
                    {
                        r = buffer.Length;
                    }
                }
                else
                    r = buffer.Length;

                if (l < r)
                {
                }
                else
                {
                    l = 1;
                    r = buffer.Length;
                }

                index = l - 1;
                howmany = r - l + 1;
            }
            #endregion


            if (!isNewLength)
            {
                string leftSubString = "";
                string mainSubString = "";
                string rightSubString = "";
                #region buffer <= leftSubString + mainSubString + rightSubString
                {
                    int leftindex = 0;
                    int lefthowmany = index - leftindex;
                    if (lefthowmany < 0)
                        lefthowmany = 0;
                    leftSubString = buffer.Substring(leftindex, lefthowmany);

                    int rightindex = index + howmany;
                    int righthowmany = buffer.Length - rightindex;
                    if (rightindex > buffer.Length - 1)
                    {
                        rightindex = buffer.Length - 1;
                        righthowmany = 0;
                    }
                    if (rightindex < 0)
                        rightindex = 0;
                    rightSubString = buffer.Substring(rightindex, righthowmany);

                    mainSubString = buffer.Substring(index, howmany);
                }
                #endregion


                //
                // Find out Filtering
                //
                AbsEnum whatEnum = ToAbc(what);
                if ((what == "") || (what == "default"))
                    whatEnum = AbsEnum.abc | AbsEnum.ABC | AbsEnum._123;
                IList<char> randomCollection = PrepareRandomCollection(whatEnum);

                IDictionary<int, bool> filtering = new Dictionary<int, bool>();
                for (int i = 1; i <= mainSubString.Length; i++)
                {
                    if (randomCollection.Any(item => item == mainSubString[i - 1]))
                    {
                        filtering[i] = true;
                    }
                    else
                        filtering[i] = false;
                }


                //
                // Replacing only filtering values
                //
                AbsEnum byWhatEnum = ToAbc(by);
                IList<char> targetCollection = PrepareRandomCollection(byWhatEnum);
                Random randomizator = new Random();
                string newMainSubString = "";
                foreach (var item in filtering)
                {
                    char innerReplacing = (char)0x00;
                    if (item.Value)
                    {
                        int value = randomizator.Next(targetCollection.Count - 1);
                        innerReplacing = targetCollection[value];
                    }
                    else
                    {
                        innerReplacing = mainSubString[item.Key - 1];
                    }
                    newMainSubString += innerReplacing;
                }
                mainSubString = newMainSubString;


                buffer = leftSubString + mainSubString + rightSubString;
                return buffer;
            }
            else
            {
                string result = Generate(byFixed, character, byRandom, by, newLength);
                return result;
            }

            
        }



        /// <summary>
        /// Get string from buffer at specific position
        /// </summary>
        /// <param name="left">left position</param>
        /// <param name="right">right position</param>
        /// <returns>inner substring from buffer</returns>
        private string Get(string left, string right)
        {
            int index = 0;
            int howmany = 0;
            #region index, howmany = left - 1, right - left + 1
            {
                int l;
                int r;
                if (int.TryParse(left, out l))
                {
                    if ((l >= 1) && (l <= buffer.Length))
                    {
                    }
                    else
                    {
                        l = 1;
                    }
                }
                else
                    l = 1;

                if (int.TryParse(right, out r))
                {
                    if ((r >= 1) && (r <= buffer.Length))
                    {
                    }
                    else
                    {
                        r = buffer.Length;
                    }
                }
                else
                    r = buffer.Length;

                if (l < r)
                {
                }
                else
                {
                    l = 1;
                    r = buffer.Length;
                }

                index = l - 1;
                howmany = r - l + 1;
            }
            #endregion

            return buffer.Substring(index, howmany);
        }


        /// <summary>
        /// Generate new substring
        /// </summary>
        /// <param name="byFixed">replacing with fixed character</param>
        /// <param name="character">single fixed character pattern</param>
        /// <param name="byRandom">replacing with random string</param>
        /// <param name="by">by what to replace ("abc", "abc!", ...)</param>
        /// <param name="newLength">new length value</param>
        /// <returns>new substring</returns>
        private string Generate(bool byFixed, char character, bool byRandom, string by, int newLength)
        {
            string result = "";

            //
            // with Fixed Single Character
            //
            if (byFixed)
            {
                if (newLength < 1)
                    newLength = 1;

                for (int i = 1; i <= newLength; i++)
                {
                    result += character;
                }
            }


            //
            // with Random Characters
            //
            if (byRandom)
            {
                AbsEnum bywhat = ToAbc(by);
                IList<char> randomCollection = PrepareRandomCollection(bywhat);

                Random randomizator = new Random();
                for (int z = 1; z <= newLength; z++)
                {
                    int value = randomizator.Next(randomCollection.Count - 1);
                    char newchar = randomCollection[value];
                    result += newchar;
                }
            }

            return result;
        }


        /// <summary>
        /// Convert string input to output
        /// </summary>
        /// <param name="input">input string</param>
        /// <returns>equal string</returns>
        private string StringConst(string input)
        {
            return input;
        }

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::




        /// <summary>
        /// Run Current Transaction on selected input item
        /// </summary>
        /// <param name="input">input number</param>
        /// <returns>output number</returns>
        public string Run(string input)
        {
            if ((isEmpty) && (isCorrect))
            {
                return input;
            }

            if (!isCorrect)
                return input;
            else
            {
                buffer = input;
                string result = "";
                foreach (var cmd in commands)
                {
                    result += cmd();
                }

                return result;
            }
        }


        /// <summary>
        /// Convert To String
        /// </summary>
        /// <returns>string result</returns>
        public override string ToString()
        {
            return String.Format("AST({0})", Command);
        }


    }
}
