﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;
using System.IO;
using System.Drawing;
using PacMap.Anonymize.HTTPRotator;
using PacMap.Anonymize;

namespace PacMap.Protocols
{
    /// <summary>
    /// Hypertext Transfer Protocol
    /// </summary>
    public class HTTP : Protocol
    {
        /// <summary>
        /// Constructs HTTP Class
        /// </summary>
        /// <param name="input">bytes array</param>
        /// <param name="owner">packet frame</param>
        public HTTP(byte[] input, Packet.Packet owner) : base(input, owner)
        {
            shortName = "HTTP";
            

            string[] strings = input.ConvertToStringCollection().ToArray();
            #region actualCommand = __GET HTTP HEADER COMMAND
            string actionPart = ""; // http action
            if (strings.Count() > 0)
            {
                header = strings[0];
                actionPart = strings[0].Split(new char[] { '/', ' ' }, StringSplitOptions.RemoveEmptyEntries).ToList()[0];
            }
            foreach (var cmd in possibleCommands)
            {
                if (cmd.ToString().ToUpper() == actionPart)
                    actualCommand = cmd;
            }
            #endregion

            if (actualCommand != CommandsEnum.UNSPECIFIED) // if http commands is supported
            {
                isCorrect = true;
                packet.Protocol = "$10" + shortName; // Coloring protocol name
                SetPacketInformation(strings);

                #region int emptyLinePosition = __FIND EMTPY LINE IN "string" = HTTP HEADER ENDING
                int emptyLinePosition = 0;
                {
                    int index = 0;
                    foreach (var line in strings)
                    {
                        if (line == "")
                            emptyLinePosition = index;
                        index++;
                    }
                }
                #endregion
                headerCollection = strings.Where(item => strings.ToList().IndexOf(item) < emptyLinePosition).ToArray(); // get http header content


                //
                // Request Parsing
                //
                if (IsRequest)
                {
                    IList<string> firstLine = strings[0].Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries).ToList();
                    version = firstLine.Last();

                    if (actualCommand == CommandsEnum.Get)
                    {
                        __get_target = firstLine[1];

                        __get_host = headerCollection.ParseHeaderIntelligence("Host");
                        //__get_userAgent = ParseHeaderIntelligence(headerCollection, "User-Agent");
                        //__get_accept = ParseHeaderIntelligence(headerCollection, "Accept");
                        //__get_acceptLanguage = ParseHeaderIntelligence(headerCollection, "Accept-Language");
                        //__get_acceptEncoding = ParseHeaderIntelligence(headerCollection, "Accept-Encoding");
                        //__get_connection = ParseHeaderIntelligence(headerCollection, "Connection");
                        //__get_referer = ParseHeaderIntelligence(headerCollection, "Referer");
                        __get_cookie = headerCollection.ParseHeaderIntelligence("Cookie");
                        //string ifModifiedSinceString = ParseHeaderIntelligence(headerCollection, "If-Modified-Since");
                        //DateTime.TryParse(ifModifiedSinceString, out __get_ifModifiedSince);
                    }

                }

                //
                // Response Parsing
                //
                if (IsResponse)
                {
                    IList<string> firstLine = strings[0].Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries).ToList();
                    version = firstLine.First();
                    string serverResultString = "";
                    for (int i = 1; i <= firstLine.Count - 1; i++)
                    {
                        if (serverResultString != "")
                            serverResultString += " ";
                        serverResultString += firstLine[i];
                    }
                    __http_serverResponded = serverResultString;


                    __http_date = headerCollection.ParseHeaderIntelligence("Date");
                    //__http_server = ParseHeaderIntelligence(headerCollection, "Server");
                    //__http_xPoweredBy = ParseHeaderIntelligence(headerCollection, "X-Powered-By");
                    __http_expires = headerCollection.ParseHeaderIntelligence("Expires");
                    //__http_pragma = ParseHeaderIntelligence(headerCollection, "PRAGMA");
                    //__http_cacheControl = ParseHeaderIntelligence(headerCollection, "Cache-control");
                    //string lastModifiedString = ParseHeaderIntelligence(headerCollection, "Last-Modified");
                    //DateTime.TryParse(lastModifiedString, out __http_lastModified);
                    //__http_vary = ParseHeaderIntelligence(headerCollection, "Vary");
                    //__http_contentType = ParseHeaderIntelligence(headerCollection, "Content-Type");
                    __http_setCookie = headerCollection.ParseHeaderIntelligence("Set-Cookie");
                    //__http_contentEncoding = ParseHeaderIntelligence(headerCollection, "Content-Encoding");
                    //__http_keepAlive = ParseHeaderIntelligence(headerCollection, "Keep-Alive");
                    //__http_connection = ParseHeaderIntelligence(headerCollection, "Connection");


                }


                //--------------------------------------------
                int lengthAlreadyRead = 0;
                foreach (var item in headerCollection)
                {
                    lengthAlreadyRead += item.Length + 2;
                }
                lengthAlreadyRead += 2;
                Stream stream = new MemoryStream(input);
                stream.Position = lengthAlreadyRead;
                int restSize = (int)(stream.Length - stream.Position);
                if (restSize >= 0)
                {
                    byte[] rest = new byte[restSize];
                    int readed = stream.Read(rest, 0, restSize);

                    if (readed > 0)
                    {
                        byteContent = rest;
                    }
                }
            }
            else
            {
                isCorrect = false;
                mainInformation = "$08[HTTP Segment]";
            }
            packet.Info = mainInformation;
        }


        /****************************************************************************************/
        // :: DATA FIELDs ::
        
        private string header = "";
        private bool isCorrect = false;
        private string version = "";
        private string[] headerCollection = null;
        private byte[] byteContent = null;
        private CommandsEnum actualCommand = CommandsEnum.UNSPECIFIED;
        public readonly IList<CommandsEnum> possibleCommands = new List<CommandsEnum>()
        {
            CommandsEnum.Http, CommandsEnum.Get, CommandsEnum.Connect, CommandsEnum.Delete, CommandsEnum.Head, CommandsEnum.Options, CommandsEnum.Post, CommandsEnum.Put, CommandsEnum.Trace
        };
        //<-- Request :: GET
        private string __get_target = "";
        private string __get_host = "";
        //private string __get_userAgent = "";
        //private string __get_accept = "";
        //private string __get_acceptLanguage = "";
        //private string __get_acceptEncoding = "";
        //private string __get_connection = "";
        //private string __get_referer = "";
        private string __get_cookie = "";
        //private DateTime __get_ifModifiedSince;
        // //>

        //<-- Response :: HTTP
        private string __http_serverResponded = "";
        private string __http_date = "";
        //private string __http_server = "";
        //private string __http_xPoweredBy = "";
        private string __http_expires = "";
        //private string __http_pragma = "";
        //private string __http_cacheControl = "";
        //private DateTime __http_lastModified;
        //private string __http_vary = "";
        //private string __http_contentType = "";
        private string __http_setCookie = "";
        //private string __http_contentEncoding = "";
        //private string __http_keepAlive = "";
        //private string __http_connection = "";
        // //>
        public enum CommandsEnum
        {
            Http,
            Get,
            Head,
            Post,
            Put,
            Delete,
            Trace,
            Options,
            Connect,
            UNSPECIFIED
        }
        
        /****************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get HTTP Protocol is Correct
        /// </summary>
        public bool IsCorrect
        {
            get
            {
                return isCorrect;
            }
        }

        /// <summary>
        /// Get HTTP Version (1.0/1.1/1.2)
        /// </summary>
        public string Version
        {
            get
            {
                string result = "";
                if (version.Length >= 4)
                {
                    if (version.Substring(0, 4) == "HTTP")
                    {
                        result = version.Split(new char[] { '/' }, StringSplitOptions.RemoveEmptyEntries).ToList().Last();
                    }
                }
                return result;
            }
        }

        /// <summary>
        /// HTTP is Request
        /// </summary>
        public bool IsRequest
        {
            get
            {
                bool result = false;
                if (actualCommand != CommandsEnum.Http)
                    result = true;
                return result;
            }
        }

        /// <summary>
        /// HTTP is Response
        /// </summary>
        public bool IsResponse
        {
            get
            {
                bool result = false;
                if (actualCommand == CommandsEnum.Http)
                    result = true;
                return result;
            }
        }

        /// <summary>
        /// HTTP Has Additional Data (byte content)
        /// </summary>
        public bool HasData
        {
            get
            {
                if (byteContent != null)
                    return true;
                else
                    return false;
            }
        }
        #endregion

        /****************************************************************************************/
        // :: FUNCTIONs ::

        /// <summary>
        /// Set Packet Information
        /// </summary>
        private void SetPacketInformation(string[] collection)
        {
            header = collection[0];
            mainInformation = header.Substring(0, 4) + "$02" + header.Substring(4, header.Length - 4); // Additional Coloring
        }

        /// <summary>
        /// Update Special Data Fields
        /// </summary>
        private void UpdateSpecialDataFields()
        {
            #region EXPORT SPECIAL DATA FIELDs into Header Collection
            //
            // Exporting special data fields into header collection
            //
            {
                IList<string> temporalCollection = headerCollection.ToList();
                if (actualCommand == CommandsEnum.Get)
                {
                    temporalCollection.Remove(headerCollection[0]);
                    string firstLine = String.Format("GET {0} {1}", __get_target, version);
                    temporalCollection.Insert(0, firstLine);

                    temporalCollection = temporalCollection.ToArray().SaveHeaderIntelligence("Host", __get_host, true);
                    temporalCollection = temporalCollection.ToArray().SaveHeaderIntelligence("Cookie", __get_cookie, true);
                }

                else if (actualCommand == CommandsEnum.Http)
                {

                }

                headerCollection = temporalCollection.ToArray();
            }
            #endregion

            SetPacketInformation(headerCollection);
        }


        /****************************************************************************************/
        // :: GLOBAL METHODs ::

        /// <summary>
        /// Save Protocol to bytes array
        /// </summary>
        /// <returns>bytes array</returns>
        public override byte[] Save()
        {
            if (!isCorrect) // if it is only HTTP Segment
            {
                return content;
            }
            else // if it is full correct HTTP content
            {
                //UpdateSpecialDataFields();

                IList<byte> headerCollectionByte = new List<byte>();
                foreach (var line in headerCollection)
                {
                    IList<byte> innerByte = new List<byte>();
                    foreach (var ch in line)
                    {
                        innerByte.Add((byte)ch);
                    }
                    innerByte.Add((byte)'\r');
                    innerByte.Add((byte)'\n');

                    headerCollectionByte = headerCollectionByte.Concat(innerByte).ToList();
                }
                headerCollectionByte.Add((byte)'\r');
                headerCollectionByte.Add((byte)'\n');

                if (HasData)
                {
                    headerCollectionByte = headerCollectionByte.Concat(byteContent).ToList();
                }


                byte[] result = headerCollectionByte.ToArray();
                return result;
            }
        }



        /// <summary>
        /// Start AnonMapping Protocol
        /// </summary>
        public override void Anonymize()
        {
            if (isCorrect)
            {
                Rotator appropriateRotator = null;
                #region actualRotator = __GET APPROPRIATE HTTP ROTATOR
                switch (actualCommand)
                {
                    case CommandsEnum.Get:
                        appropriateRotator = packet.AnonSettings.HTTP.GET_Rotator;
                        break;
                    case CommandsEnum.Connect:
                        appropriateRotator = packet.AnonSettings.HTTP.CONNECT_Rotator;
                        break;
                    case CommandsEnum.Delete:
                        appropriateRotator = packet.AnonSettings.HTTP.DELETE_Rotator;
                        break;
                    case CommandsEnum.Head:
                        appropriateRotator = packet.AnonSettings.HTTP.HEAD_Rotator;
                        break;
                    case CommandsEnum.Options:
                        appropriateRotator = packet.AnonSettings.HTTP.OPTIONS_Rotator;
                        break;
                    case CommandsEnum.Post:
                        appropriateRotator = packet.AnonSettings.HTTP.POST_Rotator;
                        break;
                    case CommandsEnum.Put:
                        appropriateRotator = packet.AnonSettings.HTTP.PUT_Rotator;
                        break;
                    case CommandsEnum.Trace:
                        appropriateRotator = packet.AnonSettings.HTTP.TRACE_Rotator;
                        break;
                    case CommandsEnum.Http:
                        appropriateRotator = packet.AnonSettings.HTTP.HTTP_Rotator;
                        break;
                }
                #endregion


                //
                // AnonMapping Special Fields
                // 
                #region AnonMapping Special Fields
                if (actualCommand == CommandsEnum.Get)
                {
                    __get_target = packet.AnonSettings.HTTP.GET_Target.Run(__get_target);
                    string __get_host_anonmapped = packet.AnonSettings.HTTP.GET_Host.Run(__get_host);
                    __get_host = packet.AnonSettings.HTTP.GET_Host_Mask.Proceed(__get_host.ConvertStringToBytes().ToArray(), __get_host_anonmapped.ConvertStringToBytes().ToArray()).ConvertToString();

                    __get_cookie = packet.AnonSettings.HTTP.GET_Cookies.Run(__get_cookie);
                }

                if (actualCommand == CommandsEnum.Http)
                {
                    __http_date = packet.AnonSettings.HTTP.HTTP_Date.Run(__http_date);
                    __http_expires = packet.AnonSettings.HTTP.HTTP_Expires.Run(__http_expires);
                    __http_setCookie = packet.AnonSettings.HTTP.HTTP_Cookies.Run(__http_setCookie);
                }
                #endregion

                //
                // AnonMapping by HTTP Rotator
                //
                headerCollection = appropriateRotator.Rotate(headerCollection).ToArray();
                UpdateSpecialDataFields();

                //
                // HTTP Responde AnonMapping
                //
                if (actualCommand == CommandsEnum.Http)
                {
                    if (HasData)
                    {
                        Anonymizator anonymizator = new Anonymizator();
                        object byteContentOut = null;
                        anonymizator.AnonMap(byteContent, out byteContentOut, packet.AnonSettings.HTTP.HTTP_Data, packet.AnonSettings.HTTP.HTTP_Data_ReplaceWith, byteContent.Length);
                        byteContent = (byte[])byteContentOut;
                    }
                }
            }
            else
            {
            }
            
        }


        /// <summary>
        /// Get Full Packet Information for Advanced Packet Viewing
        /// </summary>
        /// <returns>Specialized Information Object</returns>
        public override object GetFullInformation()
        {
            if (!IsCorrect)
                return null;

            IList<object> result = new List<object>();
            IDictionary<string, object> browserInfo = new Dictionary<string, object>();
            IList<KeyValuePair<Point, object>> browserHex = new List<KeyValuePair<Point, object>>();
            IList<string> browserGroup = new List<string>();
            result.Add(browserInfo);
            result.Add(browserHex);
            result.Add(browserGroup);


            #region __GET NAMEs
            {
                string name = "Hypertext Transfer Protocol";
                string item0 = headerCollection[0];
                IDictionary<string, object> inner = new Dictionary<string, object>();
                browserInfo[name] = inner;
                if (actualCommand == CommandsEnum.Get)
                {
                    string firstLine1 = String.Format("Request Method: {0}", actualCommand.ToString().ToUpper());
                    string firstLine2 = String.Format("Request URI: {0}", __get_target);
                    string firstLine3 = String.Format("Request Version: {0}", version);
                    IDictionary<string, object> firstLineCollection = new Dictionary<string, object>();
                    firstLineCollection[firstLine1] = null;
                    firstLineCollection[firstLine2] = null;
                    firstLineCollection[firstLine3] = null;
                    inner[item0] = firstLineCollection;
                }
                else if (actualCommand == CommandsEnum.Http)
                {
                    IDictionary<string, object> firstLineCollection = new Dictionary<string, object>();
                    string firstLine1 = String.Format("Request Version: {0}", version);
                    firstLineCollection[firstLine1] = null;
                    string[] answer = __http_serverResponded.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
                    string firstLine2 = String.Format("Status Code: {0}", answer[0]);
                    firstLineCollection[firstLine2] = null;
                    if (answer.Count() >= 2)
                    {
                        string firstLine3 = String.Format("Response Phrase: {0}", answer[1]);
                        firstLineCollection[firstLine3] = null;
                    }
                    inner[item0] = firstLineCollection;
                }
                else
                {
                    inner[item0] = null;
                }


                for (int a = 1; a <= headerCollection.Count() - 1; a++)
                {
                    string addItem = headerCollection[a];
                    inner[addItem] = null;
                }

                if (IsResponse)
                {
                    string hasDataString = String.Format("Contains Additional HTTP Data = {0}", HasData ? "Yes" : "No");
                    inner[hasDataString] = null;
                }

            }
            #endregion

            #region __GET HEX
            {

                Point nameHex = new Point(1, TotalLength);
                IList<KeyValuePair<Point, object>> innerHex = new List<KeyValuePair<Point, object>>();
                browserHex.Add(new KeyValuePair<Point, object>(nameHex, innerHex));

                Point item0Hex = new Point(1, headerCollection[0].Length + 2);
                if (actualCommand == CommandsEnum.Get)
                {
                    Point firstLine1Hex = new Point(1, 3);
                    Point firstLine2Hex = new Point(4 + 1, 4 + __get_target.Length);
                    Point firstLine3Hex = new Point(5 + __get_target.Length + 1, 5 + __get_target.Length + version.Length);
                    IList<KeyValuePair<Point, object>> firstLineCollection = new List<KeyValuePair<Point, object>>();
                    firstLineCollection.Add(new KeyValuePair<Point, object>(firstLine1Hex, null));
                    firstLineCollection.Add(new KeyValuePair<Point, object>(firstLine2Hex, null));
                    firstLineCollection.Add(new KeyValuePair<Point, object>(firstLine3Hex, null));
                    innerHex.Add(new KeyValuePair<Point, object>(item0Hex, firstLineCollection));
                }
                else if (actualCommand == CommandsEnum.Http)
                {
                    IList<KeyValuePair<Point, object>> firstLineCollection = new List<KeyValuePair<Point, object>>();
                    Point firstLine1Hex = new Point(1, version.Length);
                    firstLineCollection.Add(new KeyValuePair<Point, object>(firstLine1Hex, null));
                    string[] answer = __http_serverResponded.Split(new char[]{' '}, StringSplitOptions.RemoveEmptyEntries);
                    Point firstLine2Hex = new Point(version.Length + 1 + 1, version.Length + 1 + answer[0].Length);
                    firstLineCollection.Add(new KeyValuePair<Point,object>(firstLine2Hex, null));
                    if (answer.Count() >= 2)
                    {
                        Point firstLine3Hex = new Point(firstLine2Hex.Y + 1 + 1, firstLine2Hex.Y + 1 + answer[1].Length);
                        firstLineCollection.Add(new KeyValuePair<Point, object>(firstLine3Hex, null));
                    }
                    innerHex.Add(new KeyValuePair<Point, object>(item0Hex, firstLineCollection));
                }
                else
                {
                    innerHex.Add(new KeyValuePair<Point, object>(item0Hex, null));
                }


                int actualPosition = headerCollection[0].Length + 2;
                for (int a = 1; a <= headerCollection.Count() - 1; a++)
                {
                    string headerItem = headerCollection[a];
                    Point span = new Point(actualPosition + 1, actualPosition + headerItem.Length + 2);
                    innerHex.Add(new KeyValuePair<Point, object>(span, null));

                    actualPosition += headerItem.Length + 2;
                }
                if (IsResponse)
                {
                    Point span = Point.Empty;
                    if (!HasData)
                    {
                        span = new Point(actualPosition + 1, actualPosition + 2);
                        actualPosition += 2;
                    }
                    else
                    {
                        span = new Point(actualPosition + 2 + 1, actualPosition + 2 + byteContent.Length);
                    }
                    innerHex.Add(new KeyValuePair<Point, object>(span, null));
                }

            }
            #endregion

            #region __GET GROUP
            {
                browserGroup.Add(shortName);
            }
            #endregion

            return result;
        }



    }
}
