﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace PacMap.Protocols
{
    /// <summary>
    /// IPv6 Lobby
    /// </summary>
    public class IPv6 : Protocol
    {
        public IPv6(byte[] input, Packet.Packet owner) : base(input, owner)
        {
            shortName = "IPv6";
            Stream stream = new MemoryStream(input);

            //
            // Get Traffic Class & FlowLabel
            //
            {
                byte[] word = new byte[2];
                stream.Read(word, 0, 2);
                trafficClass = ((word[0] << 8) | word[1]) & 0x0FF0;

                byte[] word2 = new byte[2];
                stream.Read(word2, 0, 2);
                flowLabel = ((word[1] & 0x0F) << 12) | (word2[0] << 8) | word2[1];
            }

            //
            // Get Payload Length
            // 
            {
                byte[] word = new byte[2];
                stream.Read(word, 0, 2);
                payloadLength = (word[0] << 8) | word[1];
            }

            //
            // Get Next Header & HopLimit
            //
            {
                packet.Protocol = "$09IPv6";

                int nextheader = stream.ReadByte();
                nextHeaderProtocol = Protocols.ProtocolsInfo.ProtocolsNo[nextheader];

                hopLimit = stream.ReadByte();
            }


            //--------------------------------------------
            int restSize = (int)(stream.Length - stream.Position);
            byte[] rest = new byte[restSize];
            int readed = stream.Read(rest, 0, restSize);
            //
            // Parse Inner IP Protocols
            //
            switch (nextHeaderProtocol.GetProtocolNo())
            {
                case 59: // No next header
                    child = new IPv6_NoNextHeader(rest, packet);
                    break;
                case 0 : // Hop-by-Hop Options
                case 43: // Routing
                case 44 : // Fragment
                case 50 : // Encapsulating Security Payload (ESP)
                case 51 : // Authentication Header (AH)
                case 60 : // Destination Options
                case 135 : // Mobility
                    break;
            }



        }


        /*******************************************************************************************/
        // :: DATA FIELDs ::
        private int trafficClass = 0x0; // 1 byte
        private int flowLabel = 0x000; // 20 bits - 2,5 bytes
        private int payloadLength = 0x00; // 2 bytes
        private ProtocolType nextHeaderProtocol = 0x0;
        private int hopLimit = 0x0;
       

        /*******************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        

        #endregion


        /*******************************************************************************************/
        // :: GLOBAL METHODs ::



    }
}
