﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using PacMap.General;

namespace PacMap.Protocols
{
    public class IPv6_template : Protocol
    {

        public IPv6_template(byte[] input, Packet.Packet owner) : base(input, owner)
        {

        }

        /**************************************************************************************/
        // :: DATA FIELDs ::
        protected byte[] source = new byte[16];
        protected byte[] destination = new byte[16];


        /**************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get Source IP
        /// </summary>
        public string Source
        {
            get
            {
                return source.ConvertIPv6ToString();
            }
        }

        /// <summary>
        /// Get Destination IP
        /// </summary>
        public string Destination
        {
            get
            {
                return destination.ConvertIPv6ToString();
            }
        }

        /// <summary>
        /// Get Local IP
        /// </summary>
        public string Local
        {
            get
            {
                if (packet.Direction == Packet.Direction.LocalToRemote)
                    return Source;
                else
                    return Destination;
            }
        }

        /// <summary>
        /// Get Remote IP
        /// </summary>
        public string Remote
        {
            get
            {
                if (packet.Direction == Packet.Direction.RemoteToLocal)
                    return Source;
                else
                    return Destination;
            }
        }
        #endregion


        /**************************************************************************************/
        // :: GLOBAL METHODs ::

        /// <summary>
        /// Parse source and destination addresses
        /// </summary>
        /// <param name="stream"></param>
        protected void ParseAdresses(Stream stream)
        {
            {
                stream.Read(source, 0, 16);
                stream.Read(destination, 0, 16);
                packet.IPSource = Source;
                packet.IPDestination = Destination;
            }
        }
    }
}
