﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace PacMap.Tracer
{
    public class ProgressBar
    {
        /// <summary>
        /// Constructs empty maintenance of progress on Console
        /// </summary>
        public ProgressBar()
        {
            InitializeObject();
        }

        /// <summary>
        /// Constructs specialised maintenance of progress on Console
        /// </summary>
        /// <param name="title">name of maintenance</param>
        public ProgressBar(string title)
        {
            this.title = title;

            InitializeObject();
            NewOperation();
        }


        private ConsoleColor foreColor = ConsoleColor.DarkGray;
        private ConsoleColor backColor = ConsoleColor.Black;
        private ConsoleColor successColor = ConsoleColor.DarkGreen;
        private ConsoleColor failedColor = ConsoleColor.DarkRed;
        private string title = "";
        private bool activated = false;

        private int where = 0;
        private int left =  0;
        private int right = 0;

        #region PROPERTIEs
        /// <summary>
        /// Get or Set Foreground Color
        /// </summary>
        public ConsoleColor ForegroundColor
        {
            get
            {
                return foreColor;
            }
            set
            {
                foreColor = value;
            }
        }

        /// <summary>
        /// Get or Set Background Color
        /// </summary>
        public ConsoleColor BackgroundColor
        {
            get
            {
                return backColor;
            }
            set
            {
                backColor = value;
            }
        }
        #endregion

        


        /***************************************************************************************/
        // :: PRIVATE METHODs ::
        /// <summary>
        /// Initialize Object
        /// </summary>
        public void InitializeObject()
        {
        }

        /// <summary>
        /// Create new maintenance of progress on Console
        /// </summary>
        private void NewOperation()
        {
            where = Console.CursorTop;
            Console.BackgroundColor = backColor;
            Console.ForegroundColor = foreColor;


            Console.CursorLeft = 0;
            Console.CursorTop = where;
            for (int i = 0; i < Program.ConsoleMaxX; i++)
                Console.Write(" ");

            Console.CursorLeft = 0;
            Console.CursorTop = where;
            Console.Write("{0} [", title);
            left = Console.CursorLeft;

            right = Program.ConsoleMaxX - 3;
            Console.CursorLeft = right + 1;
            Console.Write("]");

            Console.CursorLeft = left;

            activated = true;
        }

        /// <summary>
        /// Show maintenance of progress on Console
        /// </summary>
        /// <param name="percentage">progress parameter</param>
        private void ShowProgressOperation(int percentage)
        {
            int max = right - left;

            double ratio = ((double)percentage) / 100;
            int howmany = (int)(2 * max * ratio);

            Console.CursorLeft = left;
            Console.CursorTop = where;

            for (int i = 0; i <= (howmany / 2 ); i++)
                Console.Write("=");

            if (howmany % 2 == 1)
                Console.Write("-");
        }

        /***************************************************************************************/
        // :: PUBLIC METHODs ::


        /// <summary>
        /// Create new maintenance of progress on Console
        /// </summary>
        /// <param name="title">name of maintenance</param>
        public void NewOperation(string title)
        {
            this.title = title;
            NewOperation();
        }


        /// <summary>
        /// Complete maintenance of progress on Console
        /// </summary>
        public void CompleteOperation()
        {
            CompleteOperation(true);
        }

        /// <summary>
        /// Complete maintenance of progress on Console with Signaling Success
        /// </summary>
        /// <param name="isSucceeded">Shows whether is succeeded</param>
        public void CompleteOperation(bool isSucceeded)
        {
            Console.CursorLeft = left - 1;
            Console.CursorTop = where;
            for (int i = left - 1; i < right + 2; i++)
                Console.Write(" ");

            Console.ForegroundColor = foreColor;
            Console.BackgroundColor = backColor;
            Console.CursorLeft = right - 4;
            Console.CursorTop = where;
            Console.WriteLine("[    ]");

            Console.CursorLeft = right - 3;
            Console.CursorTop = where;
            if (isSucceeded)
            {
                Console.ForegroundColor = successColor;
                Console.Write(" Ok ");
            }
            else
            {
                Console.ForegroundColor = failedColor;
                Console.Write("Fail");
            }

            Console.ForegroundColor = foreColor;
            Console.CursorLeft = left;
            Console.WriteLine();
            activated = false;
        }


        /// <summary>
        /// Show maintenance of progress on Console
        /// </summary>
        /// <param name="sender">event handler sender</param>
        /// <param name="e">event handler args</param>
        public void ShowProgressOperation(object sender, ProgressChangedEventArgs e)
        {
            if (activated)
                ShowProgressOperation(e.ProgressPercentage);
        }


    }
}
