﻿//********************************\\
//*
//*    (ANON-SETTINGS TEMPLATE)
//*                         TCP
//*
//*                     ver 1.0
//********************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;
using PacMap.General.Masks;
using PacMap.Anonymize.Transactions;
using System.Xml.Linq;

namespace PacMap.Anonymize.Templates.Items
{
    /// <summary>
    /// TCP Anonmapping Information Template
    /// </summary>
    public class Temp__TCP : Temp__base
    {

        /// <summary>
        /// Create Empty TCP Anonmapping Information Template
        /// </summary>
        public Temp__TCP(Template owner) : base(owner)
        {

        }

        /**********************************************************************************************/
        // :: DATA FIELDs ::
        // ==TCP=======================================================================================
        private static AnonymizationType    ___Anon__TCP__General = AnonymizationType.None;     // optional
        private static byte                 ___Anon__TCP__General_ReplaceWith = 0x00;           // optional

        private static AnonValueTransaction ___Anon__TCP__Local = new AnonValueTransaction();
        private static AnonValueTransaction ___Anon__TCP__Remote = new AnonValueTransaction();
        private static AnonValueTransaction ___Anon__TCP__Source = new AnonValueTransaction();
        private static AnonValueTransaction ___Anon__TCP__Destination = new AnonValueTransaction();
        private static MaskPorts            ___Anon__TCP__Local_Mask = new MaskPorts();
        private static MaskPorts            ___Anon__TCP__Remote_Mask = new MaskPorts();
        private static MaskPorts            ___Anon__TCP__Source_Mask = new MaskPorts();
        private static MaskPorts            ___Anon__TCP__Destination_Mask = new MaskPorts();
        private static AnonymizationType    ___Anon__TCP__SequenceNumber = AnonymizationType.None;
        private static AnonymizationType    ___Anon__TCP__AcknowledgmentNumber = AnonymizationType.None;
        private static AnonymizationType    ___Anon__TCP__Flags = AnonymizationType.None;
        private static AnonymizationType    ___Anon__TCP__WindowSize = AnonymizationType.None;
        private static AnonymizationType    ___Anon__TCP__UrgentPointer = AnonymizationType.None;
        private static AnonymizationType    ___Anon__TCP__HeaderOptions = AnonymizationType.None;
        private static AnonContentType      ___Anon__TCP__Content = AnonContentType.Standard;

        private static uint                 ___Anon__TCP__SequenceNumber_ReplaceWith = 0; //32 bit - tional
        private static uint                 ___Anon__TCP__AcknowledgmentNumber_ReplaceWith = 0; //32 bit -
        private static int                  ___Anon__TCP__Flags_ReplaceWith = 0x00;      //9 bit - optional
        private static int                  ___Anon__TCP__WindowSize_ReplaceWith = 0x0000; //16 bit - ional
        private static int                  ___Anon__TCP__UrgentPointer_ReplaceWith = 0x0000; //16 bit - al
        private static byte                 ___Anon__TCP__HeaderOptions_ReplaceWith = 0x00;     // optional
        private static byte                 ___Anon__TCP__Content_ReplaceWith = 0x00;           // optional
        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get General AnonType
        /// </summary>
        public AnonymizationType General
        {
            get
            {
                return ___Anon__TCP__General;
            }
        }

        /// <summary>
        /// Get General Replacing
        /// </summary>
        public byte General_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__General_ReplaceWith;
            }
        }



        /// <summary>
        /// Get Local AnonTransaction
        /// </summary>
        public AnonValueTransaction Local
        {
            get
            {
                return ___Anon__TCP__Local;
            }
        }

        /// <summary>
        /// Get Local Masking
        /// </summary>
        public MaskPorts Local_Mask
        {
            get
            {
                return ___Anon__TCP__Local_Mask;
            }
        }

        /// <summary>
        /// Get Remote AnonTransaction
        /// </summary>
        public AnonValueTransaction Remote
        {
            get
            {
                return ___Anon__TCP__Remote;
            }
        }

        /// <summary>
        /// Get Remote Masking
        /// </summary>
        public MaskPorts Remote_Mask
        {
            get
            {
                return ___Anon__TCP__Remote_Mask;
            }
        }

        /// <summary>
        /// Get Source AnonTransaction
        /// </summary>
        public AnonValueTransaction Source
        {
            get
            {
                return ___Anon__TCP__Source;
            }
        }

        /// <summary>
        /// Get Source Masking
        /// </summary>
        public MaskPorts Source_Mask
        {
            get
            {
                return ___Anon__TCP__Source_Mask;
            }
        }

        /// <summary>
        /// Get Destination AnonTransaction
        /// </summary>
        public AnonValueTransaction Destination
        {
            get
            {
                return ___Anon__TCP__Destination;
            }
        }

        /// <summary>
        /// Get Destination Masking
        /// </summary>
        public MaskPorts Destination_Mask
        {
            get
            {
                return ___Anon__TCP__Destination_Mask;
            }
        }

        /// <summary>
        /// Get Sequence Number AnonType
        /// </summary>
        public AnonymizationType SequenceNumber
        {
            get
            {
                return ___Anon__TCP__SequenceNumber;
            }
        }

        /// <summary>
        /// Get Sequence Number Replacing
        /// </summary>
        public uint SequenceNumber_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__SequenceNumber_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Ackowledgment Number AnonType
        /// </summary>
        public AnonymizationType AcknowledgmentNumber
        {
            get
            {
                return ___Anon__TCP__AcknowledgmentNumber;
            }
        }

        /// <summary>
        /// Get Acknowledgment Number Replacing
        /// </summary>
        public uint AcknowledgmentNumber_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__AcknowledgmentNumber_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Flags AnonType
        /// </summary>
        public AnonymizationType Flags
        {
            get
            {
                return ___Anon__TCP__Flags;
            }
        }

        /// <summary>
        /// Get Flags Replacing
        /// </summary>
        public int Flags_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__Flags_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Window Size AnonType
        /// </summary>
        public AnonymizationType WindowSize
        {
            get
            {
                return ___Anon__TCP__WindowSize;
            }
        }

        /// <summary>
        /// Get Window Size Replacing
        /// </summary>
        public int WindowSize_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__WindowSize_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Urgent Pointer AnonType
        /// </summary>
        public AnonymizationType UrgentPointer
        {
            get
            {
                return ___Anon__TCP__UrgentPointer;
            }
        }

        /// <summary>
        /// Get Urgent Pointer Replacing
        /// </summary>
        public int UrgentPointer_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__UrgentPointer_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Header Options AnonType
        /// </summary>
        public AnonymizationType HeaderOptions
        {
            get
            {
                return ___Anon__TCP__HeaderOptions;
            }
        }

        /// <summary>
        /// Get Header Options Replacing
        /// </summary>
        public byte HeaderOptions_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__HeaderOptions_ReplaceWith;
            }
        }


        /// <summary>
        /// Get Content AnonType
        /// </summary>
        public AnonContentType Content
        {
            get
            {
                return ___Anon__TCP__Content;
            }
        }

        /// <summary>
        /// Get Content Replacing
        /// </summary>
        public byte Content_ReplaceWith
        {
            get
            {
                return ___Anon__TCP__Content_ReplaceWith;
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::



        /// <summary>
        /// Import Settings from XML Element
        /// </summary>
        /// <param name="element">input xml element</param>
        public void Import(XElement element)
        {
            if (element == null)
                return;

            IEnumerable<XElement> tcp = element.Elements("option");

            //
            //TCP
            //
            #region TCP
            {
                XElement lcl = null;
                XElement rmt = null;
                XElement src = null;
                XElement dst = null;
                XElement seqN = null;
                XElement ackN = null;
                XElement flags = null;
                XElement winS = null;
                XElement urgP = null;
                XElement hOpt = null;
                XElement content = null;
                foreach (var tcp_item in tcp)
                {
                    string name = (string)tcp_item.Attribute("name");
                    if (name == "local-port")
                        lcl = tcp_item;
                    if (name == "remote-port")
                        rmt = tcp_item;
                    if (name == "source-port")
                        src = tcp_item;
                    if (name == "destination-port")
                        dst = tcp_item;
                    if (name == "sequence-number")
                        seqN = tcp_item;
                    if (name == "acknowledgment-number")
                        ackN = tcp_item;
                    if (name == "flags")
                        flags = tcp_item;
                    if (name == "window-size")
                        winS = tcp_item;
                    if (name == "urgent-pointer")
                        urgP = tcp_item;
                    if (name == "header-options")
                        hOpt = tcp_item;
                    if (name == "content")
                        content = tcp_item;
                }


                #region Local port
                // Local port
                if (lcl != null)
                {
                    string action = (string)lcl.Attribute("value-action");
                    string mask = (string)lcl.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__TCP__Local = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__TCP__Local_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("TCP Local Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("TCP Local Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("TCP Local Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion

                #region Remote port
                // Remote port
                if (rmt != null)
                {
                    string action = (string)rmt.Attribute("value-action");
                    string mask = (string)rmt.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__TCP__Remote = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__TCP__Remote_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("TCP Remote Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("TCP Remote Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("TCP Remote Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion

                #region Source port
                // Source port
                if (src != null)
                {
                    string action = (string)src.Attribute("value-action");
                    string mask = (string)src.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__TCP__Source = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__TCP__Source_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("TCP Source Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("TCP Source Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("TCP Source Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion

                #region Destination port
                // Destination port
                if (dst != null)
                {
                    string action = (string)dst.Attribute("value-action");
                    string mask = (string)dst.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__TCP__Destination = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__TCP__Destination_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("TCP Destination Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("TCP Destination Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("TCP Destination Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion


                #region Sequence Number
                // Sequence Number
                if (seqN != null)
                {
                    string anon = (string)seqN.Attribute("anon");
                    string replace = (string)seqN.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__TCP__SequenceNumber = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__SequenceNumber = anonmapping;
                                    uint value;
                                    uint.TryParse(replace, out value);
                                    ___Anon__TCP__SequenceNumber_ReplaceWith = (uint)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Sequence Number Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Sequence Number AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Acknowledgment Number
                // Acknowledgment Number
                if (ackN != null)
                {
                    string anon = (string)ackN.Attribute("anon");
                    string replace = (string)ackN.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__TCP__AcknowledgmentNumber = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__AcknowledgmentNumber = anonmapping;
                                    uint value;
                                    uint.TryParse(replace, out value);
                                    ___Anon__TCP__AcknowledgmentNumber_ReplaceWith = (uint)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Acknowledgment Number Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Acknowledgment Number AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Flags
                // Flags
                if (flags != null)
                {
                    string anon = (string)flags.Attribute("anon");
                    string replace = (string)flags.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__TCP__Flags = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__Flags = anonmapping;
                                    int value;
                                    int.TryParse(replace, out value);
                                    ___Anon__TCP__Flags_ReplaceWith = (int)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Flags Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Flags AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Window Size
                // Window Size
                if (winS != null)
                {
                    string anon = (string)winS.Attribute("anon");
                    string replace = (string)winS.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__TCP__WindowSize = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__WindowSize = anonmapping;
                                    int value;
                                    int.TryParse(replace, out value);
                                    ___Anon__TCP__WindowSize_ReplaceWith = (int)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Window Size Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Window Size AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Urgent Pointer
                // Urgent Pointer
                if (urgP != null)
                {
                    string anon = (string)urgP.Attribute("anon");
                    string replace = (string)urgP.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__TCP__UrgentPointer = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__UrgentPointer = anonmapping;
                                    int value;
                                    int.TryParse(replace, out value);
                                    ___Anon__TCP__UrgentPointer_ReplaceWith = (int)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Urgent Pointer Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Urgent Pointer AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Header Options
                // Header Options
                if (hOpt != null)
                {
                    string anon = (string)hOpt.Attribute("anon");
                    string replace = (string)hOpt.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__TCP__HeaderOptions = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__HeaderOptions = anonmapping;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__TCP__HeaderOptions_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Header Options Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Header Options AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Content
                // Content
                if (content != null)
                {
                    string anon = (string)content.Attribute("content-anon");
                    string replace = (string)content.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            if ((type == AnonContentType.Dynamic) || (type == AnonContentType.Hash) || (type == AnonContentType.Standard))
                            {
                                ___Anon__TCP__Content = type;
                            }
                            else if (type == AnonContentType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__TCP__Content = type;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__TCP__Content_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("TCP Content Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("TCP Content AnonMapping has bad value");
                        }
                    }
                }
                #endregion
            }
            #endregion
        }



        /// <summary>
        /// Export Settings into XML Element
        /// </summary>
        /// <returns>output xml element</returns>
        public XElement Export()
        {
            XElement tcp = new XElement("protocol");
            tcp.SetAttributeValue("name", "TCP");
            if (template.IsEmpty)
                return tcp;
            XElement tcpSourcePort = new XElement("option");
            XElement tcpDestPort = new XElement("option");
            XElement tcpLocalPort = new XElement("option");
            XElement tcpRemotePort = new XElement("option");
            XElement tcpSeqnum = new XElement("option");
            XElement tcpAcknum = new XElement("option");
            XElement tcpFlags = new XElement("option");
            XElement tcpWindowSize = new XElement("option");
            XElement tcpUrgentPtr = new XElement("option");
            XElement tcpOptions = new XElement("option");
            XElement tcpContent = new XElement("option");

            tcpSourcePort.SetAttributeValue("name", "source-port");
            tcpDestPort.SetAttributeValue("name", "destination-port");
            tcpLocalPort.SetAttributeValue("name", "local-port");
            tcpRemotePort.SetAttributeValue("name", "remote-port");
            tcpSeqnum.SetAttributeValue("name", "sequence-number");
            tcpAcknum.SetAttributeValue("name", "acknowledgment-number");
            tcpFlags.SetAttributeValue("name", "flags");
            tcpWindowSize.SetAttributeValue("name", "window-size");
            tcpUrgentPtr.SetAttributeValue("name", "urgent-pointer");
            tcpOptions.SetAttributeValue("name", "header-options");
            tcpContent.SetAttributeValue("name", "content");

            
            tcpSourcePort.SetAttributeValue("value-action", ___Anon__TCP__Source.Command);
            tcpDestPort.SetAttributeValue("value-action", ___Anon__TCP__Destination.Command);
            tcpLocalPort.SetAttributeValue("value-action", ___Anon__TCP__Local.Command);
            tcpRemotePort.SetAttributeValue("value-action", ___Anon__TCP__Remote.Command);
            tcpSeqnum.SetAttributeValue("anon", ___Anon__TCP__SequenceNumber.ConvertToString());
            tcpAcknum.SetAttributeValue("anon", ___Anon__TCP__AcknowledgmentNumber.ConvertToString());
            tcpFlags.SetAttributeValue("anon", ___Anon__TCP__Flags.ConvertToString());
            tcpWindowSize.SetAttributeValue("anon", ___Anon__TCP__WindowSize.ConvertToString());
            tcpUrgentPtr.SetAttributeValue("anon", ___Anon__TCP__UrgentPointer.ConvertToString());
            tcpOptions.SetAttributeValue("anon", ___Anon__TCP__HeaderOptions.ConvertToString());
            tcpContent.SetAttributeValue("content-anon", ___Anon__TCP__Content.ConvertToString());

            tcpSourcePort.SetAttributeValue("mask", ___Anon__TCP__Source_Mask.ToString());
            tcpDestPort.SetAttributeValue("mask", ___Anon__TCP__Destination_Mask.ToString());
            tcpLocalPort.SetAttributeValue("mask", ___Anon__TCP__Local_Mask.ToString());
            tcpRemotePort.SetAttributeValue("mask", ___Anon__TCP__Remote_Mask.ToString());



            if (___Anon__TCP__SequenceNumber == AnonymizationType.Static)
                tcpSeqnum.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__SequenceNumber_ReplaceWith));
            if (___Anon__TCP__AcknowledgmentNumber == AnonymizationType.Static)
                tcpAcknum.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__AcknowledgmentNumber_ReplaceWith));
            if (___Anon__TCP__Flags == AnonymizationType.Static)
                tcpFlags.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__Flags_ReplaceWith));
            if (___Anon__TCP__WindowSize == AnonymizationType.Static)
                tcpWindowSize.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__WindowSize_ReplaceWith));
            if (___Anon__TCP__UrgentPointer == AnonymizationType.Static)
                tcpUrgentPtr.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__UrgentPointer_ReplaceWith));
            if (___Anon__TCP__HeaderOptions == AnonymizationType.Static)
                tcpOptions.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__HeaderOptions_ReplaceWith));
            if (___Anon__TCP__Content == AnonContentType.Static)
                tcpContent.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__TCP__Content_ReplaceWith));


            tcp.Add(tcpLocalPort);
            tcp.Add(tcpRemotePort);
            tcp.Add(tcpSourcePort);
            tcp.Add(tcpDestPort);
            tcp.Add(tcpSeqnum);
            tcp.Add(tcpAcknum);
            tcp.Add(tcpFlags);
            tcp.Add(tcpWindowSize);
            tcp.Add(tcpUrgentPtr);
            tcp.Add(tcpOptions);
            tcp.Add(tcpContent);
            return tcp;
        }



    }
}
