﻿//********************************\\
//*
//*    (ANON-SETTINGS TEMPLATE)
//*                         UDP
//*
//*                     ver 1.0
//********************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;
using PacMap.General.Masks;
using PacMap.Anonymize.Transactions;
using System.Xml.Linq;

namespace PacMap.Anonymize.Templates.Items
{
    /// <summary>
    /// UDP Anonmapping Information Template
    /// </summary>
    public class Temp__UDP : Temp__base
    {

        /// <summary>
        /// Create Empty UDP Anonmapping Information Template
        /// </summary>
        public Temp__UDP(Template owner) : base(owner)
        {

        }

        /**********************************************************************************************/
        // :: DATA FIELDs ::
        // ==UDP=======================================================================================
        private static AnonymizationType    ___Anon__UDP__General = AnonymizationType.None;     // optional
        private static byte                 ___Anon__UDP__General_ReplaceWith = 0x00;           // optional
        
        private static AnonValueTransaction ___Anon__UDP__Local = new AnonValueTransaction();
        private static AnonValueTransaction ___Anon__UDP__Remote = new AnonValueTransaction();
        private static AnonValueTransaction ___Anon__UDP__Source = new AnonValueTransaction();
        private static AnonValueTransaction ___Anon__UDP__Destination = new AnonValueTransaction();
        private static MaskPorts            ___Anon__UDP__Local_Mask = new MaskPorts();
        private static MaskPorts            ___Anon__UDP__Remote_Mask = new MaskPorts();
        private static MaskPorts            ___Anon__UDP__Source_Mask = new MaskPorts();
        private static MaskPorts            ___Anon__UDP__Destination_Mask = new MaskPorts();
        private static AnonContentType      ___Anon__UDP__Content = AnonContentType.Standard;

        private static byte                 ___Anon__UDP__Content_ReplaceWith = 0x00;           // optional
        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get General AnonType
        /// </summary>
        public AnonymizationType General
        {
            get
            {
                return ___Anon__UDP__General;
            }
        }

        /// <summary>
        /// Get General Replacing
        /// </summary>
        public byte General_ReplaceWith
        {
            get
            {
                return ___Anon__UDP__General_ReplaceWith;
            }
        }




        /// <summary>
        /// Get Local AnonTransaction
        /// </summary>
        public AnonValueTransaction Local
        {
            get
            {
                return ___Anon__UDP__Local;
            }
        }

        /// <summary>
        /// Get Local Masking
        /// </summary>
        public MaskPorts Local_Mask
        {
            get
            {
                return ___Anon__UDP__Local_Mask;
            }
        }

        /// <summary>
        /// Get Remote AnonTransaction
        /// </summary>
        public AnonValueTransaction Remote
        {
            get
            {
                return ___Anon__UDP__Remote;
            }
        }

        /// <summary>
        /// Get Remote Masking
        /// </summary>
        public MaskPorts Remote_Mask
        {
            get
            {
                return ___Anon__UDP__Remote_Mask;
            }
        }

        /// <summary>
        /// Get Source AnonTransaction
        /// </summary>
        public AnonValueTransaction Source
        {
            get
            {
                return ___Anon__UDP__Source;
            }
        }

        /// <summary>
        /// Get Source Masking
        /// </summary>
        public MaskPorts Source_Mask
        {
            get
            {
                return ___Anon__UDP__Source_Mask;
            }
        }

        /// <summary>
        /// Get Destination AnonType
        /// </summary>
        public AnonValueTransaction Destination
        {
            get
            {
                return ___Anon__UDP__Destination;
            }
        }

        /// <summary>
        /// Get Destination Masking
        /// </summary>
        public MaskPorts Destination_Mask
        {
            get
            {
                return ___Anon__UDP__Destination_Mask;
            }
        }

        /// <summary>
        /// Get Content AnonType
        /// </summary>
        public AnonContentType Content
        {
            get
            {
                return ___Anon__UDP__Content;
            }
        }

        /// <summary>
        /// Get Content Replacing
        /// </summary>
        public byte Content_ReplaceWith
        {
            get
            {
                return ___Anon__UDP__Content_ReplaceWith;
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::



        /// <summary>
        /// Import Settings from XML Element
        /// </summary>
        /// <param name="element">input xml element</param>
        public void Import(XElement element)
        {
            if (element == null)
                return;

            IEnumerable<XElement> udp = element.Elements("option");

            //
            //UDP
            //
            #region UDP
            {
                XElement lcl = null;
                XElement rmt = null;
                XElement src = null;
                XElement dst = null;
                XElement content = null;
                foreach (var udp_item in udp)
                {
                    string name = (string)udp_item.Attribute("name");
                    if (name == "local-port")
                        lcl = udp_item;
                    if (name == "remote-port")
                        rmt = udp_item;
                    if (name == "source-port")
                        src = udp_item;
                    if (name == "destination-port")
                        dst = udp_item;
                    if (name == "content")
                        content = udp_item;
                }


                #region Local port
                // Local port
                if (lcl != null)
                {
                    string action = (string)lcl.Attribute("value-action");
                    string mask = (string)lcl.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__UDP__Local = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__UDP__Local_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("UDP Local Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("UDP Local Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("UDP Local Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion

                #region Remote port
                // Remote port
                if (rmt != null)
                {
                    string action = (string)rmt.Attribute("value-action");
                    string mask = (string)rmt.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__UDP__Remote = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__UDP__Remote_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("UDP Remote Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("UDP Remote Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("UDP Remote Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion

                #region Source port
                // Source port
                if (src != null)
                {
                    string action = (string)src.Attribute("value-action");
                    string mask = (string)src.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__UDP__Source = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__UDP__Source_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("UDP Source Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("UDP Source Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("UDP Source Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion

                #region Destination port
                // Destination port
                if (dst != null)
                {
                    string action = (string)dst.Attribute("value-action");
                    string mask = (string)dst.Attribute("mask");
                    if (action != null)
                    {
                        AnonValueTransaction trans = new AnonValueTransaction(action);
                        if (trans.IsCorrect)
                        {
                            ___Anon__UDP__Destination = trans;

                            if (mask != null)
                            {
                                MaskPorts masking = MaskPorts.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 2)))
                                        ___Anon__UDP__Destination_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("UDP Destination Port \"Mask length = 2\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("UDP Destination Port {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("UDP Destination Port {0}", trans.LastError));
                        }
                    }
                }
                #endregion


                #region Content
                // Content
                if (content != null)
                {
                    string anon = (string)content.Attribute("content-anon");
                    string replace = (string)content.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            if ((type == AnonContentType.Dynamic) || (type == AnonContentType.Hash) || (type == AnonContentType.Standard))
                            {
                                ___Anon__UDP__Content = type;
                            }
                            else if (type == AnonContentType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__UDP__Content = type;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__UDP__Content_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("UDP Content Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("UDP Content AnonMapping has bad value");
                        }
                    }
                }
                #endregion
            }
            #endregion
        }



        /// <summary>
        /// Export Settings into XML Element
        /// </summary>
        /// <returns>output xml element</returns>
        public XElement Export()
        {
            XElement udp = new XElement("protocol");
            udp.SetAttributeValue("name", "UDP");
            if (template.IsEmpty)
                return udp;
            XElement udpSourcePort = new XElement("option");
            XElement udpDestPort = new XElement("option");
            XElement udpLocalPort = new XElement("option");
            XElement udpRemotePort = new XElement("option");
            XElement udpContent = new XElement("option");

            udpSourcePort.SetAttributeValue("name", "source-port");
            udpDestPort.SetAttributeValue("name", "destination-port");
            udpLocalPort.SetAttributeValue("name", "local-port");
            udpRemotePort.SetAttributeValue("name", "remote-port");
            udpContent.SetAttributeValue("name", "content");

            udpSourcePort.SetAttributeValue("value-action", ___Anon__UDP__Source.Command);
            udpDestPort.SetAttributeValue("value-action", ___Anon__UDP__Destination.Command);
            udpLocalPort.SetAttributeValue("value-action", ___Anon__UDP__Local.Command);
            udpRemotePort.SetAttributeValue("value-action", ___Anon__UDP__Remote.Command);
            udpContent.SetAttributeValue("content-anon", ___Anon__UDP__Content.ConvertToString());
            if (___Anon__UDP__Content == AnonContentType.Static)
                udpContent.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__UDP__Content_ReplaceWith));

            udpSourcePort.SetAttributeValue("mask", ___Anon__UDP__Source_Mask.ToString());
            udpDestPort.SetAttributeValue("mask", ___Anon__UDP__Destination_Mask.ToString());
            udpLocalPort.SetAttributeValue("mask", ___Anon__UDP__Local_Mask.ToString());
            udpRemotePort.SetAttributeValue("mask", ___Anon__UDP__Remote_Mask.ToString());


            udp.Add(udpLocalPort);
            udp.Add(udpRemotePort);
            udp.Add(udpSourcePort);
            udp.Add(udpDestPort);
            udp.Add(udpContent);
            return udp;
        }



    }
}
