﻿//****************************************************************
// :: AnonTransaction Abstract Class - Anonmapping Transaction ::
//                                                    ver 1.00
//----------------------------------------------------------------
// Inherit:
//          AnonValueTransaction
//          AnonDateTransaction
//          AnonStringTransaction
//****************************************************************
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PacMap.Anonymize.Transactions
{
    /// <summary>
    /// Anonmapping Transaction Class
    /// </summary>
    public abstract class AnonTransaction
    {

        /// <summary>
        /// Construct Empty Anonmapping Transaction
        /// </summary>
        public AnonTransaction()
        {
            isCorrect = true;
            isEmpty = true;
        }


        /// <summary>
        /// Construct User Anonmapping Transaction
        /// </summary>
        /// <param name="phrase">user phrase</param>
        public AnonTransaction(string phrase)
        {
            command = phrase;
            isEmpty = false;
            isCorrect = false;
        }


        /**********************************************************************************************/
        // :: DATA FIELDs ::
        protected string command = "";
        protected bool isCorrect = false;
        protected bool isEmpty = true;
        protected bool isGlobal = false;
        protected string lastError = null;

        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get Transaction is/isnt correct
        /// </summary>
        public bool IsCorrect
        {
            get
            {
                return isCorrect;
            }
        }

        /// <summary>
        /// Get Transaction is/isnt Empty
        /// </summary>
        public bool IsEmpty
        {
            get
            {
                return isEmpty;
            }
        }

        /// <summary>
        /// Get Last Error
        /// </summary>
        public string LastError
        {
            get
            {
                return lastError;
            }
        }

        /// <summary>
        /// Get Actual Command
        /// </summary>
        public string Command
        {
            get
            {
                string result = command;
                if (IsEmpty)
                    result = "none";
                if (!IsCorrect)
                    result = "?";
                return result;
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::

        /// <summary>
        /// Run Transaction
        /// </summary>
        /// <param name="input">input object</param>
        /// <returns>output object</returns>
        public virtual object Run(object input)
        {
            return null;
        }

        /// <summary>
        /// Convert To String
        /// </summary>
        /// <returns>string result</returns>
        public override string ToString()
        {   
            return String.Format("AT({0})", Command);
        }


        
    }
}
