﻿//************************************\\
//*
//* :: CONSOLE GRAPHICS ::
//*                         class
//*                         ver 3.00
//*-----------------------------------\\
//* HISTORY:
//* #v2.00 - inputed ColoredSubstring() Method - for getting the true length of string (without color character marks)
//* #v3.00 - inpted CleanColors() Method - clean any coloring marks from string
//************************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PacMap.General
{
    public static class ConsoleGraphics
    {

        /// <summary>
        /// Print colored text on StdOut (HINT: to enable coloring use prefix "$xx" (xx means number 00 - 16))
        /// </summary>
        /// <param name="input">colored text</param>
        public static void ColoredWrite(string input)
        {
            //
            // Get positions of changing colors
            //
            IList<int> positions = new List<int>();
            int index = 0;
            foreach (var znak in input)
            {
                if (znak == '$')
                    positions.Add(index);
                index++;
            }


            //
            // Get all texted strings & colors
            //
            IList<int> colors = new List<int>();
            IList<string> strings = input.Split(new char[]{'$'}, StringSplitOptions.RemoveEmptyEntries).ToList();
            //if ((strings.Count > 1) || (positions[0] == 0))
            {
                int j = 1;
                if (positions.Count > 0)
                    if (positions[0] == 0)
                        j = 0;

                for (int i = j; i < strings.Count; i++)
                {
                    if (strings[j].Length >= 2)
                    {
                        string sub = strings[j].Substring(0, 2);
                        int value;
                        int.TryParse(sub, out value);
                        //ConsoleColor color = GetConsoleColor(value);
                        colors.Add(value);
                        strings[j] = strings[i].Substring(2, strings[j].Length - 2);
                    }
                    else
                    {
                        colors.Add(0);
                        strings[j] = "";
                    }
                    j++;
                }
            }



            //
            // Print collection
            //
            int actualStringIndex = 0;
            int actualColorIndex = 0;
            if (positions.Count != 0)
            {
                if (positions[0] == 0)
                {


                }
                else
                {
                    Console.Write(strings[0]);
                    actualStringIndex++;
                }
            }
            else
            {
                if (strings.Count != 0)
                {
                    Console.Write(strings[0]);
                    actualStringIndex++;
                }
            }
            if (strings.Count > 0)
            {
                for (int i = actualStringIndex; i < strings.Count; i++)
                {
                    int actualColoring = colors[actualColorIndex];
                    if ((actualColoring >= 0) && (actualColoring <= 15))
                        Console.ForegroundColor = GetConsoleColor(actualColoring);
                    else
                    {
                        Console.BackgroundColor = GetConsoleColor(actualColoring - 16);
                    }
                    
                    Console.Write(strings[actualStringIndex]);
                    actualColorIndex++;
                    actualStringIndex++;
                }
            }
            



        }

        /// <summary>
        /// Print colored text on StdOut with newline (HINT: to enable coloring use prefix "$xx" (xx means number 0 - 16))
        /// </summary>
        /// <param name="input"></param>
        public static void ColoredWriteLine(string input)
        {
            ColoredWrite(input);
            Console.WriteLine();
        }

        #region Directory__ConsoleColors
        public static IDictionary<ConsoleColor, int> consoleColors = new Dictionary<ConsoleColor, int>()
        {
            {ConsoleColor.Black, 0},
            {ConsoleColor.DarkBlue, 1},
            {ConsoleColor.DarkGreen, 2},
            {ConsoleColor.DarkCyan, 3},
            {ConsoleColor.DarkRed, 4},
            {ConsoleColor.DarkMagenta, 5},
            {ConsoleColor.DarkYellow, 6},
            {ConsoleColor.Gray, 7},
            {ConsoleColor.DarkGray, 8},
            {ConsoleColor.Blue, 9},
            {ConsoleColor.Green, 10},
            {ConsoleColor.Cyan, 11},
            {ConsoleColor.Red, 12},
            {ConsoleColor.Magenta, 13},
            {ConsoleColor.Yellow, 14},
            {ConsoleColor.White, 15},
        };

        private static ConsoleColor GetConsoleColor(int input)
        {
            return (consoleColors.Where(item => item.Value == input).First()).Key;
        }
        #endregion

        /// <summary>
        /// Get string Length
        /// </summary>
        /// <param name="input">colored text string</param>
        /// <returns>total length minus coloring characters</returns>
        public static int GetLength(this string input)
        {
            int total = input.Length;
            int sub = input.Where(ch => ch == '$').Count() * 3;
            return (total - sub) > 0 ? (total - sub) : 0;
        }


        /// <summary>
        /// Get True SubString from Colored String
        /// </summary>
        /// <param name="input">input string</param>
        /// <param name="index">zero-based index</param>
        /// <param name="length">total length</param>
        /// <returns>result string</returns>
        public static string ColoredSubstring(this string input, int index, int length)
        {
            string result = "";
            if (!(index < input.GetLength())) // check for right index position
                return "";
            if (!((length) <= input.GetLength())) // check for right length
                return "";
            if (length == 0)
                return "";

            bool loop = true;
            int i = index;
            int j = 0;
            while (loop)
            {
                if (input[i] != '$')
                {
                    result = result + input[i];
                    j++;
                }
                else
                {
                    result = result + '$' + input[i + 1] + input[i + 2];
                    i = i + 2;
                }

                if (j >= length)
                    loop = false;
                i++;
            }


            return result;
        }

        /// <summary>
        /// Clean Colored String from any colors
        /// </summary>
        /// <param name="input">input string</param>
        /// <returns>result string</returns>
        public static string CleanColors(this string input)
        {
            string result = "";
            

            bool loop = true;
            int j = 0;
            int i = 0;
            while (loop)
            {
                if (input[i] != '$')
                {
                    result = result + input[i];
                    j++;
                }
                else
                {
                    i = i + 2;
                }

                if (i >= input.Length-1)
                    loop = false;
                i++;
            }


            return result;
        }


    }
}
