﻿//*****************************************************************************
//
//    (( P ))      (( A ))      (( C ))      [[ M ]]      [[ A ]]      [[ P ]]
//
// :: Executable MAIN ::
//    PACKET MAPPER EXECUTABLE 
//
//    @author (Jiří Havelka)
//    @ver (= AppSettings.appVer)
//
//-----------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using PacMap.General;
using PacMap.Packet;
using PacMap.Anonymize;
using PacMap.Tracer;

namespace PacMap
{
    /// <summary>
    /// SAPI - Simple Application Programm Interface
    /// </summary>
    public static class Program
    {

        #region ADDITIONAL PROPERTIES
        private static int consoleMaxX;
        private static int consoleMaxY;
        private static ProgressBar progressBar;
        /// <summary>
        /// Error Exit Code
        /// </summary>
        private static int errorCode;

        /// <summary>
        /// Get Console Window Max Width
        /// </summary>
        public static int ConsoleMaxX
        {
            get
            {
                return consoleMaxX;
            }
        }

        /// <summary>
        /// Get Console Window Max Height
        /// </summary>
        public static int ConsoleMaxY
        {
            get
            {
                return consoleMaxY;
            }
        }

        /// <summary>
        /// Get or Set Exit Error Code
        /// </summary>
        public static int ExitErrorCode
        {
            get
            {
                return errorCode;
            }
            set
            {
                errorCode = value;
            }
        }

        /// <summary>
        /// Get Console Progress Bar Object
        /// </summary>
        public static ProgressBar ProgressBar
        {
            get
            {
                if (progressBar == null)
                    progressBar = new ProgressBar();
                return progressBar;
            }
        }
        #endregion

        /// <summary>
        /// Exectuable Main
        /// </summary>
        private static int Main()
        {
            //==:PRE_ACTIONs:=====================================================================================\\
            errorCode = 0;
            GetMaxConsole();
            AppSettings.GetCMDsFromCommandLine(); // Get commands from command line to application mode "AppSettings.AppMode"
            AppSettings.InitializeDefaults();     // !!WILL NOT BE DELETED AFTER ALL!! - Initialize Default Settings

            CheckingSilentMode();
            PrintWelcomeScreen();
            //----------------------------------------------------------------------------------------------------\\






            //==:MAIN_ACTIONs:====================================================================================\\
            ProgressTracer tracer = new ProgressTracer();
            IPacketPackager packager = new PacketPackager();
            packager.ProgressChanged += tracer.Status;

            DoMainActions(packager);
            //----------------------------------------------------------------------------------------------------\\

           





            //==:POST_ACTIONs:====================================================================================\\
            if (AppSettings.Errors.Count != 0)
            {   
                AppSettings.Errors.WriteErrors();
                if (errorCode == 0)
                    errorCode = 1;
            }
            else
                errorCode = 0;

            if ((AppSettings.AppMode != AppMode.Helper) && (AppSettings.AppMode != AppMode.AdvancedHelper) && (AppSettings.AppMode != AppMode.None) && (AppSettings.AppMode != AppMode.Version))
            {
                Console.WriteLine("Total errors: {0}", AppSettings.Errors.Count);
            }
            Console.ResetColor();
            return errorCode;
            //----------------------------------------------------------------------------------------------------\\
        }




        /// <summary>
        /// Get Console Window Screen Parametres
        /// </summary>
        private static void GetMaxConsole()
        {
            try // sometime can happen (mainly in unix MONO-runtime -- and that is always) -> these parametres throw exception, which is sad little bit
            {
                consoleMaxX = Console.WindowWidth;
                consoleMaxY = Console.WindowHeight;
            }
            catch
            {
                consoleMaxX = 80;
                consoleMaxY = 25;
            }
        }

        /// <summary>
        /// Checking for Silent Mode
        /// </summary>
        private static void CheckingSilentMode()
        {
            if (AppSettings.SilentMode)
            {
                Stream blankStream = new MemoryStream(1024 * 1024);
                TextWriter blankWriter = new StreamWriter(blankStream);
                Console.SetOut(blankWriter);
            }
        }

        /// <summary>
        /// Print Welcome Screen into STDOUT
        /// </summary>
        private static void PrintWelcomeScreen()
        {
            //
            // Show Various Application Header 
            //                                          ... (means for some app modes - show different headers)
            if (AppSettings.AppMode == AppMode.None)
                AppSettings.ShowAppHeader(false, false);
            else if (AppSettings.AppMode == AppMode.Version)
                Console.WriteLine(AppSettings.AppVer);
            else if (AppSettings.AppMode == AppMode.Unspecified)
                AppSettings.ShowAppHeader(false, true);
            else
                AppSettings.ShowAppHeader();


            //
            // Error command line
            //                                          ... (if something goes wrong)
            if (AppSettings.AppMode == AppMode.Unspecified)
            {
                errorCode = 1;
                GeneralExt.WriteErrors(AppSettings.CMDLErrors);
            }

            //
            // Helper
            //
            if (AppSettings.AppMode == AppMode.Helper)
            {
                AppSettings.ShowUsage(true, false);
            }
            else if (AppSettings.AppMode == AppMode.AdvancedHelper)
            {
                AppSettings.ShowUsage(false, false);
            }

        }

        /// <summary>
        /// Do the MAIN Action Procedures
        /// </summary>
        /// <param name="packager">action object</param>
        private static void DoMainActions(IPacketPackager packager)
        {  
            //
            // Show Trace File Content
            //
            if (AppSettings.AppMode == AppMode.ShowTraceFileContent)
            {
                ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));
                packager.ShowTraceFileContent();
            }


            //
            // Show Simple Information
            //
            if (AppSettings.AppMode == AppMode.ShowSimplePacketInfo)
            {
                ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));
                packager.ShowSimplePacketInfo();
            }


            //
            // Show Advanced Information
            //
            if (AppSettings.AppMode == AppMode.ShowAdvancedPacketInfo)
            {
                ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));
                packager.ShowAdvancedPacketInfo();
            }



            //
            // Print Trace File Content
            //
            if (AppSettings.AppMode == AppMode.PrintTraceFileContent)
            {
                ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));

                ProgressBar.NewOperation("Exporting to file");
                ProgressBar.CompleteOperation(packager.PrintTraceFileContent(AppSettings.Filenames[1]));
            }

            //
            // Print Simple Information
            //
            if (AppSettings.AppMode == AppMode.PrintAdvancedPacketInfo)
            {
                ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));

                ProgressBar.NewOperation("Exporting to file");
                ProgressBar.CompleteOperation(packager.PrintSimplePacketInfo(AppSettings.Filenames[1]));
            }




            //
            // Default AnonMappings
            //
            if (AppSettings.AppMode == AppMode.AnonMappings)
            {
                ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));
                ProgressBar.CompleteOperation(packager.Anonmap());
                ProgressBar.CompleteOperation(packager.Save(AppSettings.Filenames[1].FullName));
            }


            //
            // AnonMappings with XML
            //
            if (AppSettings.AppMode == AppMode.ParsingXML)
            {
                ProgressBar.NewOperation("Parsing XML");
                bool operationCompleted = AppSettings.OpenConfig(AppSettings.Filenames[0].FullName);
                if (AppSettings.Errors.Count == 0)
                {
                    ProgressBar.CompleteOperation(); // completion ParsingXML OK

                    ProgressBar.CompleteOperation(packager.LoadFile(AppSettings.Filenames[0]));
                    ProgressBar.CompleteOperation(packager.Anonmap());
                    ProgressBar.CompleteOperation(packager.Save(AppSettings.Filenames[1].FullName));
                }
                else
                    ProgressBar.CompleteOperation(false); // completion ParsingXML FAILED
            }




            //
            // Change Default Anonmappings Settings
            //
            if (AppSettings.AppMode == AppMode.ChangeDefaults)
            {
                ProgressBar.NewOperation("Parsing XML");
                bool operationCompleted = AppSettings.OpenConfig(AppSettings.Filenames[0].FullName);
                ProgressBar.CompleteOperation(operationCompleted);
                
                if (operationCompleted)
                {   
                    ProgressBar.NewOperation("Saving new default settings");
                    ProgressBar.CompleteOperation(AppSettings.SaveNewDefaults());
                }
            }



            //
            // Create Default XML Configuration
            //
            if (AppSettings.AppMode == AppMode.CreateConfig)
            {
                ProgressBar.NewOperation(String.Format("Creating default XML \"{0}\"...", AppSettings.Filenames[0].Name));
                ProgressBar.CompleteOperation(AppSettings.CreateConfig(AppSettings.Filenames[0].FullName));
            }
        }

    }









}
