﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace PacMap.Protocols
{
    /// <summary>
    /// IPv6 - No Next Header
    /// </summary>
    public class IPv6_NoNextHeader : IPv6_template
    {
        /// <summary>
        /// Create IPv6 (No Next Header)
        /// </summary>
        /// <param name="input"></param>
        /// <param name="owner"></param>
        public IPv6_NoNextHeader(byte[] input, Packet.Packet owner) : base(input, owner)
        {
            shortName = "IPv6 No Next Header";
            Stream stream = new MemoryStream(input);

            //
            // Finalize Packet Protocol Info
            //
            packet.Info = "$01" + shortName;
            packet.ProtocolNo = Protocols.ProtocolsInfo.GetProtocolNo(protocol);


            //
            // Get Source & Destination IPs Address
            //
            ParseAdresses(stream);

            //--------------------------------------------
            int restSize = (int)(stream.Length - stream.Position);
            byte[] rest = new byte[restSize];
            int readed = stream.Read(rest, 0, restSize);

            if (readed == 0)
                return;

            data = rest;
        }


        private ProtocolType protocol = ProtocolType.IPv6_NoNxt;
        private byte[] data = null;

    }
}
