﻿//*******************************************\\
//* 
//* :: A N O N - S E T T I N G s
//*                        T E M P L A T E ::
//*
//*      . . p   r   o   f   i   l   e . .
//*
//*------------------------------------------\\
//* class: Template
//* ver: 2.00
//*------------------------------------------\\
//* := Saving Anon-Settings
//*------------------------------------------\\
//* HISTORY:
//* v2.00 - edited single protocol interface
//*******************************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

using PacMap.General;
using PacMap.Anonymize.Templates.Items;

namespace PacMap.Anonymize.Templates
{
    /// <summary>
    /// xASTP - XML Anonmapping Settings Template Profile
    /// </summary>
    public class Template
    {

        /// <summary>
        /// Constructs xASTP - Anonmapping Settings Template Profile
        /// </summary>
        /// <param name="innerName">template name</param>
        public Template(string innerName)
        {
            name = innerName;
            if (name == "default")
                isDefault = true;
            if (name == "$empty$")
                isEmpty = true;


            ipv4 = new Temp__IPv4(this);
            tcp = new Temp__TCP(this);
            udp = new Temp__UDP(this);
            http = new Temp__HTTP(this);
        }

        /**********************************************************************************************/
        // :: DATA FIELDs ::
        private bool isDefault = false;
        private bool isEmpty = false;
        private string name = "";

        //
        // Identification (profile identifiers)
        //                            ...unique identification is given by local & remote IPs + local & remote PORTs
        private string localIP = "";
        private string remoteIP = "";
        private int localPort = 0;
        private int remotePort = 0;

        //
        // Data
        //                            ... contains specified template information for certain protocols
        private Temp__IPv4 ipv4 = null;
        private Temp__TCP tcp = null;
        private Temp__UDP udp = null;
        private Temp__HTTP http = null;

        // ==GENERAL PROTOCOL==========================================================================
        private static AnonymizationType ___Anon__General = AnonymizationType.None;
        private static byte              ___Anon__General_ReplaceWith = 0x00;
        
        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get Local IP Attached to Unique Template Profile
        /// </summary>
        public string LocalIP
        {
            get
            {
                return localIP;
            }
        }

        /// <summary>
        /// Get Remote IP Attached To Unique Template Profile
        /// </summary>
        public string RemoteIP
        {
            get
            {
                return remoteIP;
            }
        }

        /// <summary>
        /// Get Local Port Attached To Unique Template Profile
        /// </summary>
        public int LocalPort
        {
            get
            {
                return localPort;
            }
        }

        /// <summary>
        /// Get Remote Port Attached  To Unique Template Profile
        /// </summary>
        public int RemotePort
        {
            get
            {
                return remotePort;
            }
        }

        /// <summary>
        /// Get IPv4 Settings
        /// </summary>
        public Temp__IPv4 IPv4
        {
            get
            {
                return ipv4;
            }
        }

        /// <summary>
        /// Get TCP Settings
        /// </summary>
        public Temp__TCP TCP
        {
            get
            {
                return tcp;
            }
        }

        /// <summary>
        /// Get UDP Settings
        /// </summary>
        public Temp__UDP UDP
        {
            get
            {
                return udp;
            }
        }

        /// <summary>
        /// Get HTTP Settings
        /// </summary>
        public Temp__HTTP HTTP
        {
            get
            {
                return http;
            }
        }

        /// <summary>
        /// Get General AnonType
        /// </summary>
        public AnonymizationType General
        {
            get
            {
                return ___Anon__General;
            }
        }

        /// <summary>
        /// Get General Replacing
        /// </summary>
        public byte General_ReplaceWith
        {
            get
            {
                return ___Anon__General_ReplaceWith;
            }
        }

        /// <summary>
        /// Template Profile is empty
        /// </summary>
        public bool IsEmpty
        {
            get
            {
                return isEmpty;
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::


        /// <summary>
        /// Import Settings from XML Element
        /// </summary>
        /// <param name="element">input xml element</param>
        public void Import(XElement element)
        {
            if (element == null)
                return;

            string localIPString = (string)element.Attribute("local-ip");       // get unique identifiers
            string remoteIPString = (string)element.Attribute("remote-ip");     // ...
            string localPortString = (string)element.Attribute("local-port");   // ...
            string remotePortString = (string)element.Attribute("remote-port"); // ...

            int localPortInt;
            int RemotePortInt;
            bool localPortParsedSuccessfully = int.TryParse(localPortString, out localPortInt);    // convert to int type
            bool remotePortParsedSuccessfully = int.TryParse(remotePortString, out RemotePortInt); // ...
            if ((localIPString != null) && (remoteIPString != null) && (localPortParsedSuccessfully) && (remotePortParsedSuccessfully)) // if all goes well...
            {
                localIP = localIPString;    // ...assign identifiers into the class data fields
                remoteIP = remoteIPString;
                localPort = localPortInt;
                remotePort = RemotePortInt;
            }
            else // if some error appears...
            {
                localIP = "0.0.0.0"; // set data fields to zero
                remoteIP = "0.0.0.0";
                localPort = 0;
                remotePort = 0;
            }

            IEnumerable<XElement> protocols = element.Elements("protocol"); // take subelement "protocol" from XML "element"

            XElement generalProtocol = null;
            XElement ipv4 = null;
            XElement tcp = null;
            XElement udp = null;
            XElement http = null;
            foreach (var protocol in protocols) // for each founded subelement -> assign known XElement classed to the that protocol subelement
            {
                string name = (string)protocol.Attribute("name");  // get name of subelement
                if (name == "general")                             
                    generalProtocol = protocol;
                if (name == "IPv4")
                    ipv4 = protocol;
                if (name == "TCP")
                    tcp = protocol;
                if (name == "UDP")
                    udp = protocol;
                if (name == "HTTP")
                    http = protocol;
            }


            if (generalProtocol != null)
            {

            }

            //
            // IPv4 Settings Importing
            //
            if (ipv4 != null)
            {
                IPv4.Import(ipv4);
            }

            //
            // TCP Settings Importing
            //
            if (tcp != null)
            {
                TCP.Import(tcp);
            }

            //
            // UDP Settings Importing
            //
            if (udp != null)
            {
                UDP.Import(udp);
            }

            //
            // HTTP Settings Importing
            //
            if (http != null)
            {
                HTTP.Import(http);
            }
        }



        /// <summary>
        /// Export Settings into XML Element
        /// </summary>
        /// <returns>output xml element</returns>
        public XElement Export()
        {
            XElement template = new XElement("template"); // this is root XElement, which is goint to be returned
            if (!isEmpty)
            {
                template.SetAttributeValue("name", name);
                if (isDefault) // if this Template is Default, write no identifiers to the output XML
                {
                }
                else
                {
                    template.SetAttributeValue("local-ip", localIP);       // exporting unique profile identifiers
                    template.SetAttributeValue("remote-ip", remoteIP);     // ...
                    template.SetAttributeValue("local-port", localPort);   // ...
                    template.SetAttributeValue("remote-port", remotePort); // ...
                }
            }
            else // if template is empty, or it is probably errored
            {
                template.SetAttributeValue("name", "user-template-1");
                template.SetAttributeValue("local-ip", "0.0.0.0");
                template.SetAttributeValue("remote-ip", "0.0.0.0");
                template.SetAttributeValue("local-port", 0);
                template.SetAttributeValue("remote-port", 0);
                return template;
            }


            //
            // General Packet
            //
            XElement general = new XElement("protocol");
            general.SetAttributeValue("name", "general");
            general.SetAttributeValue("anon", ___Anon__General.ConvertToString());
            if (___Anon__General == AnonymizationType.Static)
                general.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__General_ReplaceWith));
            template.Add(general);


            //
            // IPv4 Settings Exporting
            //
            #region IPv4
            {
                template.Add(ipv4.Export()); // export IPv4 Anon-Settings into XML element
            }
            #endregion


            //
            // TCP Settings Exporting
            //
            #region TCP
            {       
                template.Add(tcp.Export());
            }
            #endregion


            //
            // UDP Settings Exporting
            //
            #region UDP
            {       
                template.Add(udp.Export());
            }
            #endregion



            //
            // HTTP Settings Exporting
            //
            #region HTTP
            {       
                template.Add(http.Export());
            }
            #endregion


            return template;
        }




    }
}
