﻿//*********************************************\\
//*
//*   A P P L I C A T I O N
//*                            :: M O D E ::
//* 
//*********************************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PacMap.General
{   
    /// <summary>
    /// Application Actions
    /// </summary>
    public enum AppMode
    {
        None,
        Unspecified,

        /// <summary>
        /// Show USAGE Help
        /// </summary>
        Helper,

        /// <summary>
        /// Show XML USAGE Help
        /// </summary>
        AdvancedHelper,


        /// <summary>
        /// Show App Version
        /// </summary>
        Version,

        //------------------------------
        //------------------------------

        /// <summary>
        /// Show Trace File Content
        /// </summary>
        ShowTraceFileContent,

        /// <summary>
        /// Show Simple Packet Information
        /// </summary>
        ShowSimplePacketInfo,

        /// <summary>
        /// Print Trace File Content to FILE
        /// </summary>
        PrintTraceFileContent,

        /// <summary>
        /// Print Advanced Packet Information to FILE
        /// </summary>
        PrintAdvancedPacketInfo,

        /// <summary>
        /// Show Advanced Packet Information
        /// </summary>
        ShowAdvancedPacketInfo,

        /// <summary>
        /// Run Mapping
        /// </summary>
        AnonMappings,

        /// <summary>
        /// Parse configuration XML file
        /// </summary>
        ParsingXML,

        /// <summary>
        /// Create Default XML Configuration File
        /// </summary>
        CreateConfig,

        /// <summary>
        /// Change Defaults with XML
        /// </summary>
        ChangeDefaults,
    }


    /// <summary>
    /// Application Flags
    /// </summary>
    [Flags]
    public enum AppFlags
    {

    }
}