﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PacMap.Packet
{
    /// <summary>
    /// Packet Frame
    /// </summary>
    public class Frame
    {

        /// <summary>
        /// Create Packet Frame
        /// </summary>
        /// <param name="input">16 bytes of expected data</param>
        public Frame(byte[] input)
        {
            //
            // Get Epoch Time 
            //
            {
                // have no idea yet
            }

            //
            // Get Captured Packet Size (9th & 10th position)
            //
            {
                capturedPacketSize = (input[9] << 8) | input[8]; // it is in reverse order!
            }

            //
            // Get Original Packet Size (13th & 14th position)
            //
            {
                originalPacketSize = (input[13] << 8) | input[12];
            }

            originalData = input;
        }


        //private DateTime epochTime = 
        private byte[] originalData = null;
        private int originalPacketSize = 0;
        private int capturedPacketSize = 0;

        /// <summary>
        /// Get Original Packet Size
        /// </summary>
        public int OriginalPacketSize
        {
            get
            {
                return originalPacketSize;
            }
        }

        /// <summary>
        /// Get Captured Packet Size
        /// </summary>
        public int CapturedPacketSize
        {
            get
            {
                return capturedPacketSize;
            }
        }

        /// <summary>
        /// Get Frame class into the bytes of array
        /// </summary>
        /// <returns></returns>
        public byte[] Save()
        {
            IList<byte> changedData = originalData.ToList();
            {
                changedData[9] = (byte)((capturedPacketSize & 0xFF00) >> 8);
                changedData[8] = (byte)(capturedPacketSize & 0x00FF);
            }
            {
                changedData[13] = (byte)((originalPacketSize & 0xFF00) >> 8);
                changedData[12] = (byte)(originalPacketSize & 0x00FF);
            }

            return changedData.ToArray();
        }


        /// <summary>
        /// Change "Original Packet Size" & "Captured Packet Size"
        /// </summary>
        /// <param name="originalPacketSize">original packet size in bytes</param>
        /// <param name="CapturedPacketSize">captured packet size in bytes</param>
        public void ChangeFrameLenghtInformation(int originalSize, int capturedSize)
        {
            if (originalPacketSize == capturedPacketSize)
            {
                originalPacketSize = originalSize;
                capturedPacketSize = capturedSize;
            }
            else
            {
                capturedPacketSize = capturedSize;
            }
        }


    }
}
