﻿//******************************************* *\\
//*
//*  T E M P L A T E     C O L L E C T I O N
//*
//*                                     ver 1.0
//******************************************* *\\
//* := Container of "Template" class instances
//******************************************* *\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using System.ComponentModel;

namespace PacMap.Anonymize.Templates
{
    public class TemplatesCollection
    {
        /// <summary>
        /// XML Anonmapping Settings Templates
        /// </summary>
        public TemplatesCollection()
        {
            general = new Template("default");
            collection = new Dictionary<string, Template>();
        }

        /**********************************************************************************************/
        // :: DATA FIELDs ::
        private Template general;
        private IDictionary<string, Template> collection;

        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get Default Template
        /// </summary>
        public Template Default
        {
            get
            {
                return general;
            }
        }

        /// <summary>
        /// Get Template Items
        /// </summary>
        public IList<Template> Items
        {
            get
            {
                return collection.Values.ToList();
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::

        /// <summary>
        /// Get Additional Anonmapping Information Template
        /// </summary>
        /// <param name="name">template identification name</param>
        /// <returns>Template instance</returns>
        public Template GetAdditionalTemplate(string name) // return Template from "collection"
        {
            if (collection.ContainsKey(name))
                return collection[name];
            else
                return null;
        }



        /// <summary>
        /// Import Settings from XML Element
        /// </summary>
        /// <param name="element">input xml element</param>
        public void Import(XElement element)
        {
            IEnumerable<XElement> templates = element.Elements("template");
            if (templates != null)
            {

                XElement generalXML = null;
                foreach (var template in templates)
                {
                    string name = (string)template.Attribute("name");
                    if (name == "default")
                        generalXML = template;
                }



                if (generalXML != null)
                {
                    general.Import(generalXML);
                    templates = templates.Where(item => (string)item.Attribute("name") != "default");
                }



                foreach (var template in templates)
                {
                    string name = (string)template.Attribute("name");

                    if (!collection.ContainsKey(name))
                    {
                        Template newTemplate = new Template(name);
                        newTemplate.Import(template);
                        collection[name] = newTemplate;
                    }
                }


                collection = collection.Where(item => (item.Value.LocalIP != "0.0.0.0") && (item.Value.RemoteIP != "0.0.0.0")).ToDictionary(item => item.Key, item => item.Value);



            }
        }



        /// <summary>
        /// Export Settings into XML Element
        /// </summary>
        /// <returns>output xml element</returns>
        public XElement Export()
        {
            XElement templates = new XElement("templates");
            templates.Add(general.Export());


            if (collection.Count != 0)
            {
                foreach (var item in collection.Values)
                {
                    templates.Add(item.Export());
                }
            }
            else
            {
                Template newtemp = new Template("$empty$");
                templates.Add(newtemp.Export());
            }


            return templates;
        }





    }
}
