﻿//===========================================================================================\\
//
//
//     ::]C[.            ::[O].            ::]R[.            ::]E[.
//
//                                                       ASI - Application Settings Interface -
//                                                           -                       ver 3.00 -
//===========================================================================================\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Drawing;
using System.Xml.Linq;

using PacMap.Anonymize;
using PacMap.General.Masks;
using PacMap.Anonymize.Transactions;
using PacMap.Anonymize.Templates;
using PacMap.Additionals.Exporting;



namespace PacMap.General
{
    /// <summary>
    /// Default Application Settings and Basic Initilizing Functions
    /// </summary>
    public static class AppSettings
    {
        /*********************************************************************************************/
        // :: APP GLOBAL VARIABLEs ::
        // ============================================================================================
        // :: GLOBAL SETTINGs ::
        private static string appName = "PACMAP - PacketMapper";
        private static string appVer = "1.04";
        // :: DEFAULT ANON SETTINGs ::        
        private static bool                ___Sett__RecalculateChecksums = true;
        private static bool                ___Sett__SetBadChecksumToBad = true;
        private static HashType            ___Sett__GeneralHashType = HashType.User;
        private static string              ___Sett__GeneralHashUserOptions = "default";
        private static TemplatesCollection ___Sett__Defaults = new TemplatesCollection();
        // ============================================================================================
        /*********************************************************************************************/
        #region USAGE
        // :: USAGEs ::
        /// <summary>
        /// Basic CMDLine USAGE
        /// </summary>
        private static string ___menu_CMDs =
            "-a   Start Anonmappings all packets in;" +
            "     trace file with default settings; ;" +
            
            "-s   Show trace file content;" +
            "-ss  Show simple packets information;" +
            "-sss Show advanced packets information; ;" +

            "-p   Print simple intel into FILE;" +
            "-pp  Print more intel into FILE; ;" +

            "-c   Create default XML configuration;" +
            "     file; ;" +

            "-h   Useful help for cmdline;" +
            "-hh  Useful help for XML config";

        /// <summary>
        /// Filename(s) USAGE
        /// </summary>
        private static string ___menu_FNs =
            "input and output pcap file; ;" +
            "$08<or>; ;" +
            "at least input file ->;" +
            " -> output's form would be:; ;" +
            " $08[original]$15_modified$08.pcap";

        /// <summary>
        /// Options USAGE
        /// </summary>
        private static string ___menu_FLAGs =
            "$07-q  $08Activate quiet/silent mode; ;" +

            "$08[printing option];" +
            "$14-txt  $06Plain Text (default);" +
            "$14-tab  $06Text with tabs between every single items;" +
            "$14-csv  $06CSV file-format (text with semi-colons)";

        /// <summary>
        /// Advanced XML Usage
        /// </summary>
        private static string ___menu_XMLs = 
            "$15XML Tags:\r\n \r\n" +
            "$08> $07General Settings$08:\r\n \r\n" +
            "  $07- Hashing type:\r\n" +
            "  $15hashtype $08= \"$07user$08\" ││ \"$07mda5$08\" ││ \"$07sha1$08\"\r\n \r\n" +
            "  $07- For user hashing is available hashing function settings:\r\n" +
            "  $15hashfunc $08= \"$07default$08\" ││ regular expression \"($07op$08.$07value$08)^+\"\r\n \r\n" +
            "         $07op $08= \"$07+$08\" ││ \"$07-$08\" ││ \"$07*$08\" ││ \"$07/$08\" ││ \"$07%$08\"\r\n" +
            "         $07value $08= $08[numeric value]\r\n" +
            "         $08(example: \"$07+7%128*4-77/10$08\")\r\n \r\n \r\n" +
            "$08> $07Anonmappings Settings$08:\r\n \r\n" +
            "  - set up is managed with several templates\r\n" +
            "  - templates can by attached to unique communication profiles\r\n \r\n" +
            "  $07- Anonmappings type:\r\n" +
            "  $15anon $08= \"$07none$08\" ││ $07\"static$08\" ││ $07dynamic $08││ $07hash\r\n \r\n" +
            "  $07- Content anonmappings settings$08:\r\n" +
            "  $15content-anon $08= \"$07standard$08\" ││ \"$07static$08\" ││ \"$07dynamic$08\" ││ \"$07hash$08\"\r\n \r\n" +
            "  $07- For static anonmappings is available \"replace\" tag:\r\n" +
            "  $15replace $08= [byte value = 0 - 255] ││ [word value = 0 - 65535] ││\r\n" +
            "         $08[double world value = 0 - 4294967295] ││\r\n" +
            "         \"$070.0.0.0$08\" for IP addresses\r\n \r\n" +
            "  $07- Anonmappings mask\r\n" +
            "  $15mask $08= \"$07none$08\" ││ \"$070x$08($0700$08)^+\" ││ \"($0700000000$08)^+$07b$08\" ││\r\n" +
            "         $08(where $07TRUE $08= original, $07FALSE $08= proceed anonmappings)\r\n \r\n" +
            "         $08e.g. \"$07XXX.X--.---.---$08\" for IPv4 address mask ││\r\n" +
            "         $08e.g. \"$07XX---$08\" for TCP/UDP ports mask\r\n" +
            "         $08(where \"$07X$08\" = decimal position to keep original value,\r\n" +
            "                $08\"$07-$08\" = decimal position to proceed anonmappings\r\n \r\n" +
            "         $08e.g. \"$07-.X.X$08\" for HTTP DNS mask \r\n" +
            "         $08(where 1st 2 right \"$07X$08\" correspond 1st and 2nd domain level, \r\n" +
            "         $08 3rd domain lvl will $07be $08anonmapped) \r\n \r\n" +
            "  $07- Value transaction:\r\n" +
            "  $15value-action $08= \"$07none$08\" ││ \"$07op$08.$07numvalue$08\"\r\n \r\n" +
            "         $07op $08= \"\" / \"$07+$08\" / \"$07-$08\"\r\n" +
            "         $07numvalue $08= [numeric value] $08││ \"$07RANDOM(l,r)$08\" ││ \"$07RANDOM(l,x,r)$08\"\r\n" +
            "         $07l $08= [left span value]\r\n" +
            "         $07r $08= [right span value]\r\n" +
            "         $07x $08= [unique random value enabled]\r\n" +
            "         $08(example: \"$07+RANDOM(20,x,60)$08\")\r\n \r\n" +
            "  $07- Date transaction:\r\n" +
            "  $15date-action $08= \"$07D1$08\" ││ \"$07(D1,D2)$08\" ││ \r\n" + 
            "         \"$07(D1,D2):D3$08\" ││ \"$07(D1,D2):(D3,D4)$08\"\r\n" +
            "         $08(where D1, D2, D3 & D4 are single dates) \r\n \r\n" +
            "  $07- String transaction:\r\n" +
            "  $15string-action = \"cmd(+cmd)^+\" \r\n" +
            "         $07cmd $08= $07[const string] $08││ $07[replace cmd] $08││ $07[generate cmd] $08││ $07[get cmd] \r\n \r\n" +
            "         $08[const string] : $07'$08[string]$07' \r\n" +
            "         $08[replace cmd]  : Static variations: \r\n" +
            "                           $07REPLACE(char) \r\n" +
            "                           REPLACE(what,char) \r\n" +
            "                           REPLACE(left,right,char) \r\n" +
            "                           REPLACE(left,right,what,char) \r\n \r\n" +
            "                          $08Dynamic variations: \r\n" +
            "                           $07REPLACE() \r\n" +
            "                           REPLACE(left,right) \r\n" +
            "                           REPLACE(by) \r\n" +
            "                           REPLACE(what,by) \r\n" +
            "                           REPLACE(left,right,by) \r\n" +
            "                           REPLACE(left,right,what,by) \r\n \r\n" +
            "                           REPLACE(char):[newlength] \r\n" +
            "                           REPLACE():[newlength] \r\n" +
            "                           REPLACE(by):[newlength] \r\n \r\n" +
            "         $08[generate cmd]  : $07GENERATE(char):[newlength] \r\n" +
            "                           GENERATE(by):[newlength] \r\n \r\n" +
            "         $08[get cmd]       : $07GET() \r\n" +
            "                           GET(left,right) \r\n \r\n" +
            "         $08inner items: [string] - any texted string \r\n" +
            "                      left     - left position where starts substring \r\n" +
            "                      right    - right position where ends substring \r\n" +
            "                      char     - one single replacing character \r\n" +
            "                      what     - what to be replaced: \r\n" +
            "                                 $07abc$08[x] ││ $07123$08[x] ││ $07abc123$08[x] \r\n" +
            "                                  (abc - random lower and upper characters) \r\n" +
            "                                  (123 - random numbers) \r\n" +
            "                                  (abc123 - random numbers and characters) \r\n" +
            "                                 [x] = \"\" ││ \"$07!$08\" ││ \"$07!!$08\" \r\n" +
            "                                  (\"\" - default) \r\n" +
            "                                  (\"$07!$08\" - add characters (.:,semicolon+-*/%)) \r\n" +
            "                                  (\"$07!!$08\" - add blank spaces) \r\n" +
            "                               (default is abc123) \r\n" +
            "                      by       - replacing content \r\n" +
            "                               (same syntax as $07what$08) \r\n" +
            "                      newlength - length value \r\n" +
            "";
        


        private static string titles = "\r\n" +
            "   ▄▄mm▄˛            ♦█Ţ           ¸                                          \r\n" +
            "   ◄█► ██∟            █Ţ          ██                                           \r\n" +
            "   ◄█► ██¨┌▀▀█ç ˛■▀▀■ █Ţ▀█▀ ▄█▀█ç◄██▀¨                                         \r\n" +
            "   ◄█►▀▀¨  _▄█Ť █Ţ    ███¸  ██■▀♦ █Â         ▄■■▄■■                            \r\n" +
            "   ]█Ç    ██_█► ██▄_▄ █Ţ▀█˛ ██▄_▄ ██_        Ť  Ş  Ą                           \r\n" +
            "  └▀▀▀!   ´▀^▀▀¨ ▀▀▀¨▀▀▀¨▀▀! ▀▀▀¨ ´▀▀       ]∟  Ş  █  ♥♥■ █♥♥▄ ♠♥♥■¸ ■▀▀ç █♥♥∟ \r\n" +
            "                                            █   Ş  ]Ç  ▄█ ║   ►├   Â¶¨˛▄▀ Ţ    \r\n" +
            "                                            █   Ş   ►▄▀`█ ║ ▄♦ ├ ˛█¨¶■▀ ▄ Ţ    \r\n" +
            "                                            ►   Â   █▀▲▲☻ █■´  ├■▀   ♦▄ ┘ &    \r\n" +
            "                                           ¶f       █     ║    ├               \r\n" +
            "                                           █►       █Ç    ║    ├               \r\n" +
            "                                           ¨         `    ´    ´               \r";

        #endregion

        #region CMDLine Errors
        private enum TypicalCMDLErrorsEnum
        {
            TooManyParameters,
            MissingArgs,
            CannotFindFile,
            BadOrUnknownCMD,   
            BadOrUnknownFileFormat,
            _Warning_FileWillBeOverwritten
        }
        private readonly static IDictionary<TypicalCMDLErrorsEnum, string> typicalCMDLErrorsLanguageConvertor = new Dictionary<TypicalCMDLErrorsEnum, string>()
        {
            {TypicalCMDLErrorsEnum.TooManyParameters, "Too many parameters"},
            {TypicalCMDLErrorsEnum.MissingArgs, "Missing argument(s)"},
            {TypicalCMDLErrorsEnum.CannotFindFile, "Cannot find input filename"},
            {TypicalCMDLErrorsEnum.BadOrUnknownCMD, "Bad or Unknown command(s)"},
            {TypicalCMDLErrorsEnum.BadOrUnknownFileFormat, "Bad or Unknown file format"},

        };
        #endregion

        /************************************************************************************************/








        /*************************************/
        // :: PROPERTIEs ::
        #region PROPERTIES
        /// <summary>
        /// Get Application Name
        /// </summary>
        public static string AppName
        {
            get
            {
                return appName;
            }
        }

        /// <summary>
        /// Get Application Version
        /// </summary>
        public static string AppVer
        {
            get
            {
                return appVer;
            }
        }

        /// <summary>
        /// Get Application Filename
        /// </summary>
        public static string AppFile
        {
            get
            {
                return appFile;
            }
        }

        /// <summary>
        /// Get Application Mode
        /// </summary>
        public static AppMode AppMode
        {
            get
            {
                return appMode;
            }
        }

        /// <summary>
        /// Get FileFormat for Exporting/Printing
        /// </summary>
        public static FileFormat FileFormat
        {
            get
            {
                return fileFormat;
            }
        }
        /// <summary>
        /// Get any CMDLine Error
        /// </summary>
        public static bool AnyCMDLError
        {
            get
            {
                if (cmdlerrors.Count == 0)
                    return false;
                else
                    return true;
            }
        }

        /// <summary>
        /// Get Collection of CMDLine Errors
        /// </summary>
        public static IList<string> CMDLErrors
        {
            get
            {
                return cmdlerrors;
            }
        }

        /// <summary>
        /// Get Collection of Application Errors
        /// </summary>
        public static IList<string> Errors
        {
            get
            {
                return errors;
            }
        }

        
        /// <summary>
        /// Get selected filenames
        /// </summary>
        public static IList<FileInfo> Filenames
        {
            get
            {
                return filenames;
            }
        }

        /// <summary>
        /// Get Templates Settings
        /// </summary>
        public static TemplatesCollection Templates
        {
            get
            {
                return ___Sett__Defaults;
            }
        }

        /// <summary>
        /// Get whether Recalculating Checksum is ON/OFF
        /// </summary>
        public static bool RecalculateChecksums
        {
            get
            {
                return ___Sett__RecalculateChecksums;
            }
        }

        /// <summary>
        /// Get whether Bad Checksums is going to be BAD / or NOT
        /// </summary>
        public static bool SetBadChecksumsToBad
        {
            get
            {
                return ___Sett__SetBadChecksumToBad;
            }
        }

        /// <summary>
        /// Get Hashing Kind
        /// </summary>
        public static HashType HashingKind
        {
            get
            {
                return ___Sett__GeneralHashType;
            }
        }

        /// <summary>
        /// Get Extended Hashing Kind
        /// </summary>
        public static string HashingKindExtended
        {
            get
            {
                return ___Sett__GeneralHashUserOptions;
            }
        }

        /// <summary>
        /// Get Silent Mode
        /// </summary>
        public static bool SilentMode
        {
            get
            {
                return silentMode;
            }
        }
        #endregion

       

        /*************************************/
        // :: OTHER DATA FIELDs ::
        private static string appFile = null;
        private static AppMode appMode = General.AppMode.None;
        private static FileFormat fileFormat = FileFormat.TXT;
        private static readonly IList<FileInfo> filenames = new List<FileInfo>();
        private static readonly IList<string> cmdlerrors = new List<string>();
        private static readonly IList<string> errors = new List<string>();
        // Switches
        private static bool silentMode = false; // silent mode

        /*************************************/
        // :: INITIALIZE FUNCTIONs ::
        /// <summary>
        /// Get Commands from command line and Export them into the "AppSettings.AppMode" and "AppSettings.Filenames".
        /// </summary>
        public static void GetCMDsFromCommandLine()
        {
            IList<string> args = Environment.GetCommandLineArgs().ToList(); // get whole command line into the string collection
            appFile = (new FileInfo(args[0])).Name;                         // get application binary name (e.g. for correct view of Usage Help)
            args = args.Where(item => args.IndexOf(item) > 0).ToList();     // re-get all command line commands except the first one (except the binary executable name)

            appMode = General.AppMode.None;

            //
            // Check the 1st argument => General Decision for Application
            //
            if (args.Count >= 1)
            {
                if (args[0].ArgCheck("anon"))             // -a AnonMappings
                {
                    appMode = General.AppMode.AnonMappings;
                }


                else if (args[0].ArgCheck("show"))         // -s Show Trace File Content
                {
                    appMode = General.AppMode.ShowTraceFileContent;
                }
                else if (args[0].ArgCheck("ss", "ss", 2))        // -ss Show Simple Packet Information
                {
                    appMode = General.AppMode.ShowSimplePacketInfo;
                }
                else if (args[0].ArgCheck("sss", "sss", 3))          // -sss Show Advanced Packet Information
                {
                    appMode = General.AppMode.ShowAdvancedPacketInfo;
                }




                else if (args[0].ArgCheck("print"))
                {
                    appMode = General.AppMode.PrintTraceFileContent;
                }
                else if (args[0].ArgCheck("pp", "pp", 2))
                {
                    appMode = General.AppMode.PrintAdvancedPacketInfo;
                }





                else if ((args[0].ArgCheck("help")) || (args[0].ArgCheck("help", "?", 1)))        // (-h) or (-?) or (/?) Show USAGE Help
                {
                    appMode = General.AppMode.Helper;
                }
                else if (((args[0].ArgCheck("advanced-help", "hh", 2) || args[0].ArgCheck("advanced-help", "??", 2)))) // Show XML USAGE Help
                {
                    appMode = General.AppMode.AdvancedHelper;
                }
                else if (args[0].ArgCheck("version"))     // -v Show version
                {
                    appMode = General.AppMode.Version;
                }





                else if (args[0].ArgCheck("createXML"))   // -c Create Default XML Configuration File
                {
                    appMode = General.AppMode.CreateConfig;
                }
                else if (args[0].ArgCheck("change-defaults", "d", 1))           // -d Change Defaults
                {
                    appMode = General.AppMode.ChangeDefaults;
                }





                else if (args[0].ArgCheck()) // check if actual expression is argument (means beginning with "-" or "--" or "/")
                {
                    cmdlerrors.Add(String.Format("{0} ?{1}?", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownCMD], args[0]));
                    appMode = General.AppMode.Unspecified; // unknown user sequence
                }

                else // if it is not argument, could be a filename of XML configuration file
                {
                    string possibleFile = args[0];
                    FileInfo possibleFileInfo = null;
                    try
                    {
                        possibleFileInfo = new FileInfo(possibleFile);
                    }
                    catch
                    {
                    }
                    if (possibleFileInfo != null)
                    {
                        if (possibleFileInfo.Exists) // so testing it existance
                        {
                            appMode = General.AppMode.ParsingXML; // if exists, parsingXML file mode enabled
                            filenames.Add(possibleFileInfo);      // input filename added
                        }
                        else
                        {
                            cmdlerrors.Add(String.Format("{0} ?{1}?", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], args[0]));
                            appMode = General.AppMode.Unspecified; // bad user sequence
                        }
                    }
                    else // it is not a file, => means bead user sequence
                    {
                        cmdlerrors.Add(String.Format("{0} ?{1}?", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownCMD], args[0]));
                        appMode = General.AppMode.Unspecified; // bad user sequence
                    }
                }
            }







            //
            // AnonMappings
            //
            if (AppMode == General.AppMode.AnonMappings)
            {
                if (args.Count == 3) // input and output filename was typed
                {
                    FileInfo input = new FileInfo(args[1]);
                    FileInfo output = new FileInfo(args[2]);
                    if (input.Exists)
                    {
                        filenames.Add(input);
                        filenames.Add(output);
                    }
                    else
                    {
                        cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input));
                        appMode = General.AppMode.Unspecified;
                    }
                }


                else if (args.Count == 2) // just input filename
                {
                    FileInfo input = new FileInfo(args[1]);
                    if (input.Exists)
                    {
                        string[] groups = args[1].Split(new char[] { '.' }, StringSplitOptions.RemoveEmptyEntries);
                        if ((groups.Last().ToLower() == "pcap") && (groups.Count() > 1)) // if there is file extension "pcap" -> 
                        {
                            groups = groups.Take(groups.Count() - 1).ToArray();          // -> remove it
                        }
                        groups[0] = groups[0] + "_modified"; // to name add modified expression
                        string newName = "";
                        foreach (var group in groups) // concat all strings
                        {
                            if (newName != "")
                                newName = newName + ".";
                            newName = newName + group;
                        }
                        newName = newName + ".pcap";  // and concat extension "pcap" to the resulting filename
                        FileInfo output = new FileInfo(newName);

                        filenames.Add(input);
                        filenames.Add(output);
                    }
                    else
                    {
                        cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input));
                        appMode = General.AppMode.Unspecified;
                    }
                }
                else if (args.Count > 3)
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.TooManyParameters]);
                    appMode = General.AppMode.Unspecified;
                }
                else
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.MissingArgs]);
                    appMode = General.AppMode.Unspecified;
                }
            }



            //
            // Show TraceFile Content, Simple or Advanced Packet Information
            //
            if ((AppMode == General.AppMode.ShowTraceFileContent) || (AppMode == General.AppMode.ShowSimplePacketInfo) || (AppMode == General.AppMode.ShowAdvancedPacketInfo))
            {
                if (args.Count == 2)
                {
                    FileInfo input = new FileInfo(args[1]);
                    if (input.Exists)
                    {
                        filenames.Add(input);
                    }
                    else
                    {
                        cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input));
                        appMode = General.AppMode.Unspecified;
                    }
                }
                else if (args.Count > 2)
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.TooManyParameters]);
                    appMode = General.AppMode.Unspecified;
                }
                else
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.MissingArgs]);
                    appMode = General.AppMode.Unspecified;
                }
            }



            //
            // Activate Printing Possibilities
            //
            if ((AppMode == General.AppMode.PrintTraceFileContent) || (AppMode == General.AppMode.PrintAdvancedPacketInfo))
            {
                #region 3-parameters processing
                // Two arguments [-p filename]
                if (args.Count == 3)
                {
                    #region importing filename processing
                    {
                        FileInfo input = null;
                        try
                        {
                            input = new FileInfo(args[1]);
                        }
                        catch
                        {
                        }

                        if (input != null)
                        {
                            if (input.Exists)
                            {
                                filenames.Add(input);
                            }
                            else
                            {
                                cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input));
                                appMode = General.AppMode.Unspecified;
                            }
                        }
                        else
                        {
                            cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownCMD], args[1]));
                            appMode = General.AppMode.Unspecified;
                        }
                    }
                    #endregion

                    #region exporting filename processing
                    {
                        FileInfo input = null;
                        try
                        {
                            input = new FileInfo(args[2]);
                        }
                        catch
                        {
                        }

                        if (input != null)
                        {
                            filenames.Add(input);
                        }
                        else
                        {
                            cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownCMD], args[2]));
                            appMode = General.AppMode.Unspecified;
                        }
                    }
                    #endregion
                }
                #endregion

                #region 4-parameters processing
                // Three arguments [-p filename -csv]
                else if (args.Count == 4)
                {
                    #region importing filename processing
                    {
                        FileInfo input = null;
                        try
                        {
                            input = new FileInfo(args[1]);
                        }
                        catch
                        {
                        }

                        if (input != null)
                        {
                            if (input.Exists)
                            {
                                filenames.Add(input);
                            }
                            else
                            {
                                cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input));
                                appMode = General.AppMode.Unspecified;
                            }
                        }
                        else
                        {
                            cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownCMD], args[1]));
                            appMode = General.AppMode.Unspecified;
                        }
                    }
                    #endregion

                    #region exporting filename processing
                    {
                        FileInfo input = null;
                        try
                        {
                            input = new FileInfo(args[2]);
                        }
                        catch
                        {
                        }

                        if (input != null)
                        {
                            filenames.Add(input);
                        }
                        else
                        {
                            cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownCMD], args[2]));
                            appMode = General.AppMode.Unspecified;
                        }
                    }
                    #endregion

                    #region Checking FileFormat...
                    {
                        if (args[3].ArgCheck("plain", "txt", 3))
                        {
                            fileFormat = Additionals.Exporting.FileFormat.TXT;
                        }
                        else if (args[3].ArgCheck("semi-colon", "csv", 3))
                        {
                            fileFormat = Additionals.Exporting.FileFormat.CSV;
                        }
                        else if ((args[3].ArgCheck("tabular", "doc", 3)) || (args[3].ArgCheck("table", "odt", 3)) || (args[3].ArgCheck("tabulator", "tab", 3)))
                        {
                            fileFormat = Additionals.Exporting.FileFormat.ODT;
                        }
                        else
                        {
                            cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.BadOrUnknownFileFormat], args[3]));
                            appMode = General.AppMode.Unspecified;
                        }
                    }
                    #endregion
                }
                #endregion

                #region bad-parameters processing
                // Other bad possibilites
                else if (args.Count > 3) // more arguments
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.TooManyParameters]);
                    appMode = General.AppMode.Unspecified;
                }
                else // less arguments
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.MissingArgs]);
                    appMode = General.AppMode.Unspecified;
                }
                #endregion
            }



            //
            // Create XML Configuration File
            //
            if (AppMode == General.AppMode.CreateConfig)
            {
                if (args.Count == 2)
                {
                    FileInfo input = new FileInfo(args[1]);
                    {
                        filenames.Add(input);
                    }
                }
                else if (args.Count > 2)
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.TooManyParameters]);
                    appMode = General.AppMode.Unspecified;
                }
                else
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.MissingArgs]);
                    appMode = General.AppMode.Unspecified;
                }
            }



            if (AppMode == General.AppMode.ChangeDefaults)
            {
                if (args.Count == 2)
                {
                    FileInfo input = new FileInfo(args[1]);
                    if (input.Exists)
                    {
                        filenames.Add(input);
                    }
                    else
                    {
                        cmdlerrors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input));
                        appMode = General.AppMode.Unspecified;
                    }
                }
                else if (args.Count > 2)
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.TooManyParameters]);
                    appMode = General.AppMode.Unspecified;
                }
                else
                {
                    cmdlerrors.Add(typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.MissingArgs]);
                    appMode = General.AppMode.Unspecified;
                }
            }




            if ((args.Any(item => item.ArgCheck("silent", "q", 1))) || (args.Any(item => item.ArgCheck("quiet", "q", 1))))
                silentMode = true;

        }



        /// <summary>
        /// !!MISSING!! - Initialize Default Settings from Implicit Settings File
        /// </summary>
        public static void InitializeDefaults()
        {
            // not ready for operate
        }

        /// <summary>
        /// !!MISSING!! - Save new Default Settings into Implicit Settings File
        /// </summary>
        public static bool SaveNewDefaults()
        {
            bool bResult = true;
            // not ready as well

            return bResult;
        }




        /// <summary>
        /// Show Default Application Title, Name and Version
        /// </summary>
        public static void ShowAppHeader()
        {
            ShowAppHeader(true, true);
        }

        /// <summary>
        /// Show Application Title with Advanced View
        /// </summary>
        /// <param name="showTitle">Show Title Image</param>
        /// <param name="showVersion">Show Default Title Header</param>
        public static void ShowAppHeader(bool showTitle, bool showVersion)
        {
            if (showTitle)
            {
                if (Program.ConsoleMaxX >= 79)
                    ConsoleGraphics.ColoredWrite(String.Format("$08{0}", titles));
            }

            if (showVersion)
                ConsoleGraphics.ColoredWriteLine(String.Format("$07{0} - $08{1}", AppSettings.appName, AppSettings.AppVer));
            else
            {
                ConsoleGraphics.ColoredWriteLine(String.Format("$15{0}", AppSettings.AppName));
                ConsoleGraphics.ColoredWriteLine(String.Format("$08version: {0}", AppSettings.AppVer));
            }
            Console.ResetColor();

            try
            {
                Console.Title = AppName; 
            }
            catch
            {
            }
        }



        /// <summary>
        /// Show General Application Usage on StdOut
        /// </summary>
        /// <param name="showBasic">Show only basic == TRUE</param>
        /// <param name="showBoth">Show both == TRUE</param>
        public static void ShowUsage(bool showBasic, bool showBoth)
        {
            char[] seps = { '\r', '\n', ';' };
            int appFileMaxName = 15;
            string appFileName = "";
            if (appFile.Length != appFileMaxName)
            {
                if (appFile.Length > appFileMaxName)
                {
                    appFileName = appFile.Substring(0, appFileMaxName - 3);
                    appFileName = appFileName + "...";
                }
                else if (appFile.Length < appFileMaxName)
                {
                    string blank = "               ";
                    appFileName = appFile + blank.Substring(0, appFileMaxName - appFile.Length);
                }
            }


            IList<string> cmds = ___menu_CMDs.Split(seps, StringSplitOptions.RemoveEmptyEntries);
            IList<string> fns = ___menu_FNs.Split(seps, StringSplitOptions.RemoveEmptyEntries);
            IList<string> fns_additionals = new List<string>();
            foreach (var cmd in cmds)
            {
                fns_additionals.Add("");
            }
            fns = fns.Concat(fns_additionals).ToList();
            IList<string> flags = ___menu_FLAGs.Split(seps, StringSplitOptions.RemoveEmptyEntries);
            IList<string> xmls = ___menu_XMLs.Split(seps, StringSplitOptions.RemoveEmptyEntries);

            Console.WriteLine();

            //
            // Command Line USAGE Follows
            //
            if ((showBasic) || (showBoth))
            {
                ConsoleGraphics.ColoredWriteLine(String.Format("$08:: Running from command line"));
                ConsoleGraphics.ColoredWriteLine(String.Format("$07USAGE: {0} [cmds] [filename(s)] [option(s)]", appFileName));
                string empty = "";
                string line = "";
                for (int i = 1; i <= appFileName.Length; i++)
                {
                    empty += " ";
                    line += "─";
                }
                ConsoleGraphics.ColoredWriteLine(String.Format("       $08{0} │      │             │", empty));
                ConsoleGraphics.ColoredWrite(String.Format("───────{0}─┘      └────────────(│)──< $07{1}\r", line, fns[0]));
                ConsoleGraphics.ColoredWriteLine("$08+─[$07Commands:$08]");
                ConsoleGraphics.ColoredWriteLine(String.Format("       {0}                      $08│     $07{1}\r", empty, fns[1]));

                int index = 1;
                foreach (var cmd in cmds)
                {
                    index++;
                    ConsoleGraphics.ColoredWrite(String.Format("       {0}                      $08│     $07{1}\r", empty, fns[index]));
                    ConsoleGraphics.ColoredWriteLine(String.Format(" $07{0}", cmd));
                }

                ConsoleGraphics.ColoredWriteLine(String.Format("       {0}                      $08│", empty));
                ConsoleGraphics.ColoredWrite(String.Format("$08───────{0}──────────────────────┘\r", line));
                ConsoleGraphics.ColoredWriteLine("$08+─[$07Options:$08]");
                ConsoleGraphics.ColoredWriteLine("");
                foreach (var flag in flags)
                {
                    ConsoleGraphics.ColoredWriteLine(String.Format(" $07{0}", flag));
                }
            }


            //
            // XML plugin USAGE Follows
            //
            if ((!showBasic) || (showBoth))
            {
                ConsoleGraphics.ColoredWriteLine(String.Format("$08:: Running with XML configuration file"));
                ConsoleGraphics.ColoredWriteLine(String.Format("$07USAGE: {0} [xml_configuration_filename]", appFileName));
                Console.WriteLine();

                foreach (var xml in xmls)
                {
                    ConsoleGraphics.ColoredWriteLine(String.Format(" {0}", xml));
                }
            }

            Console.WriteLine();
            Console.ResetColor();
        }

        /// <summary>
        /// Add New Error to Errors Collection
        /// </summary>
        /// <param name="errorString">error string</param>
        public static void AddNewError(string errorString)
        {
            errors.Add(errorString);
        }

        /// <summary>
        /// Open XML Configuration File With Advanced Settings
        /// </summary>
        /// <param name="path">XML filename to open</param>
        /// <returns>TRUE = if success</returns>
        public static bool OpenConfig(string path)
        {
            bool bResult = true;

            XDocument document = null;
            try
            {
                document = XDocument.Load(path);
            }
            catch (Exception ex)
            {
                AppSettings.errors.Add(String.Format("XML document \"{0}\" is in bad format", path));
                AppSettings.errors.Add(String.Format("{0}", ex.Message));
                return false;
            }
            XElement root = document.Element("configuration");
            IEnumerable<XElement> treeroot = root.Elements("settings");
            IEnumerable<XElement> flow = null;
            IEnumerable<XElement> general = null;
            XElement templates = null;
            foreach (var treeitem in treeroot)
            {
                string name = (string)treeitem.Attribute("name");
                if (name == "in/out")
                    flow = treeitem.Elements("item");
                else if (name == "general-settings")
                    general = treeitem.Elements("item");
                else if (name == "anonmappings")
                    templates = treeitem.Element("templates");
            }
            if (flow == null)
            {
                if (appMode == General.AppMode.ParsingXML)
                {
                    errors.Add("Input and output tag is missing");
                    bResult = false;
                    return bResult;
                }
            }

            if (general == null)
            {
                errors.Add("General settings was not found");
            }

            if (templates == null)
            {
                errors.Add("No template was found");
            }


            #region _optional flow
            // optional flow
            {
                XElement input = null;
                XElement output = null;
                foreach (var file in flow)
                {
                    string name = (string)file.Attribute("name");
                    if (name == "input")
                        input = file;
                    if (name == "output")
                        output = file;
                }
                if ((input == null) || (output == null))
                {
                    bResult = false;
                    if (input == null)
                        errors.Add("Input file is missing");
                    if (output == null)
                        errors.Add("Output file is missing");
                    return bResult;
                }
                else
                {
                    FileInfo inputFI = new FileInfo(input.Value);
                    FileInfo outputFI = new FileInfo(output.Value);

                    if (inputFI.Exists)
                    {
                        filenames.Clear();
                        filenames.Add(inputFI);
                        filenames.Add(outputFI);
                    }
                    else
                    {
                        errors.Add(String.Format("{0} \"{1}\"", typicalCMDLErrorsLanguageConvertor[TypicalCMDLErrorsEnum.CannotFindFile], input.Value));
                        bResult = false;
                        return bResult;
                    }
                }

                
            }
            #endregion

            #region _general settings
            // general settings
            {
                IEnumerable<XElement> checksums = null;
                IEnumerable<XElement> hashs = null;
                foreach (var generalItem in general)
                {
                    string name = (string)generalItem.Attribute("name");
                    if (name == "checksums")
                        checksums = generalItem.Elements("option");
                    if (name == "hash")
                        hashs = generalItem.Elements("option");
                }
                if ((checksums == null) || (hashs == null))
                {
                    
                }
                else
                {
                    // checksums
                    {
                        XElement __option_recalculateXML = null;
                        XElement __option_setBadToBadXML = null;
                        foreach (var checksum in checksums)
                        {
                            string name = (string)checksum.Attribute("name");
                            if (name == "recalculate")
                                __option_recalculateXML = checksum;
                            if (name == "set-bad-one-to-bad")
                                __option_setBadToBadXML = checksum;
                        }
                        if ((__option_recalculateXML == null) || (__option_setBadToBadXML == null))
                        {
                            
                        }
                        else
                        {
                            int __option_recalculate;
                            int __option_setBadToBad;
                            int.TryParse(__option_recalculateXML.Value, out __option_recalculate);
                            int.TryParse(__option_setBadToBadXML.Value, out __option_setBadToBad);
                            ___Sett__RecalculateChecksums = (__option_recalculate == 1) ? true : false;
                            ___Sett__SetBadChecksumToBad = (__option_setBadToBad == 1) ? true : false;
                        }
                    }

                    // user hash
                    {
                        XElement __option_hashTypeXML = null;
                        XElement __option_userHashXML = null;
                        foreach (var hash in hashs)
                        {
                            string name = (string)hash.Attribute("name");
                            if (name == "general-hash-type")
                                __option_hashTypeXML = hash;
                            if (name == "user-hash-function")
                                __option_userHashXML = hash;
                        }
                        if ((__option_hashTypeXML != null) && (__option_userHashXML == null))
                        {
                            bResult = false;
                            errors.Add(string.Format("User Hash Function Expected"));
                            return bResult;
                        }
                        else
                        {
                            string generalHashTypeString = (string)__option_hashTypeXML.Attribute("hashtype");
                            string userHashFunction = (string)__option_userHashXML.Attribute("hashfunc");
                            if ((generalHashTypeString != null) && (userHashFunction != null))
                            {
                                HashType generalHashType = HashType.User;
                                if (generalHashTypeString == HashType.User.ToString().ToLower())
                                    generalHashType = HashType.User;
                                else if (generalHashTypeString == HashType.MD5.ToString().ToLower())
                                    generalHashType = HashType.MD5;
                                else if (generalHashTypeString == HashType.SHA1.ToString().ToLower())
                                    generalHashType = HashType.SHA1;
                                ___Sett__GeneralHashType = generalHashType;

                                if ((generalHashType == HashType.MD5) || (generalHashType == HashType.SHA1))
                                    userHashFunction = "default";
                                ___Sett__GeneralHashUserOptions = userHashFunction;
                            }
                        }
                    }
                }

            }
            #endregion

            #region _anonmapping option
            //
            // == ANONYMIZING OPTIONS ==
            //
            {
                ___Sett__Defaults.Import(templates);
            }
            #endregion

            return bResult;
        }


        /// <summary>
        /// Create XML Configuration File With Defualt Settings
        /// </summary>
        /// <param name="path">path to new config file</param>
        /// <returns>TRUE = if success</returns>
        public static bool CreateConfig(string path)
        {
            XDocument document = new XDocument();
            XElement root = new XElement("configuration");
            document.Add(root);

            #region _optional flow
            // optional flow
            {
                XElement files = new XElement("settings");
                files.SetAttributeValue("name", "in/out");
                XElement in_file = new XElement("item");
                in_file.SetAttributeValue("name", "input");
                in_file.Value = "in.pcap";
                XElement out_file = new XElement("item");
                out_file.SetAttributeValue("name", "output");
                out_file.Value = "out.pcap";
                files.Add(in_file);
                files.Add(out_file);
                root.Add(files);
            }
            #endregion

            #region _general settings
            // general settings
            {
                XElement general = new XElement("settings");
                general.SetAttributeValue("name", "general-settings");
                XElement checksum = new XElement("item");
                checksum.SetAttributeValue("name", "checksums");
                XElement checksum_option1 = new XElement("option");
                checksum_option1.SetAttributeValue("name", "recalculate");
                checksum_option1.SetValue(___Sett__RecalculateChecksums ? 1 : 0);
                XElement checksum_option2 = new XElement("option");
                checksum_option2.SetAttributeValue("name", "set-bad-one-to-bad");
                checksum_option2.SetValue(___Sett__SetBadChecksumToBad ? 1 : 0);
                checksum.Add(checksum_option1);
                checksum.Add(checksum_option2);
                general.Add(checksum);

                XElement hashSettings = new XElement("item");
                hashSettings.SetAttributeValue("name", "hash");
                XElement hashSettingsType = new XElement("option");
                hashSettingsType.SetAttributeValue("name", "general-hash-type");
                hashSettingsType.SetAttributeValue("hashtype", ___Sett__GeneralHashType.ToString().ToLower());
                XElement hashUserSettings = new XElement("option");
                hashUserSettings.SetAttributeValue("name", "user-hash-function");
                hashUserSettings.SetAttributeValue("hashfunc", ___Sett__GeneralHashUserOptions);
                hashSettings.Add(hashSettingsType);
                hashSettings.Add(hashUserSettings);
                general.Add(hashSettings);
                
                root.Add(general);
            }
            #endregion

            //
            // == ANONYMIZING OPTIONS ==
            //
            {
                XElement anonmappings = new XElement("settings");
                anonmappings.SetAttributeValue("name", "anonmappings");

                anonmappings.Add(___Sett__Defaults.Export());
                root.Add(anonmappings);
            }



            bool bresult = true;
            try
            {
                document.Save(path);
            }
            catch
            {
                bresult = false;
                errors.Add(String.Format("Cannot save to \"{0}\"", path));
            }
            return bresult;
        }


    }
}
