﻿//********************************\\
//*
//*    (ANON-SETTINGS TEMPLATE)
//*                        IPv4
//*
//*                     ver 1.0
//********************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;
using PacMap.General.Masks;
using PacMap.Anonymize.Transactions;
using System.Xml.Linq;

namespace PacMap.Anonymize.Templates.Items
{
    /// <summary>
    /// IPv4 Anonmapping Information Template
    /// </summary>
    public class Temp__IPv4 : Temp__base
    {

        /// <summary>
        /// Create Empty IPv4 Anonmapping Information Template
        /// </summary>
        public Temp__IPv4(Template owner) : base(owner)
        {
            ___Anon__IPv4__Ttl.MaxValue = 255;
            ___Anon__IPv4__Ttl.MinValue = 0;
        }

        /**********************************************************************************************/
        // :: DATA FIELDs ::
        // ==IPv4======================================================================================
        private static AnonymizationType    ___Anon__IPv4__General = AnonymizationType.None;    // optional
        private static byte                 ___Anon__IPv4__General_ReplaceWith = 0x00;          // optional

        private static AnonymizationType    ___Anon__IPv4__Local = AnonymizationType.Hash;
        private static AnonymizationType    ___Anon__IPv4__Remote = AnonymizationType.Hash;
        private static AnonymizationType    ___Anon__IPv4__Source = AnonymizationType.None;
        private static AnonymizationType    ___Anon__IPv4__Destination = AnonymizationType.None;
        private static MaskIPv4Address      ___Anon__IPv4__Local_Mask = new MaskIPv4Address();
        private static MaskIPv4Address      ___Anon__IPv4__Remote_Mask = new MaskIPv4Address();
        private static MaskIPv4Address      ___Anon__IPv4__Source_Mask = new MaskIPv4Address();
        private static MaskIPv4Address      ___Anon__IPv4__Destination_Mask = new MaskIPv4Address();
        private static AnonymizationType    ___Anon__IPv4__Tos = AnonymizationType.None;
        private static AnonymizationType    ___Anon__IPv4__Identification = AnonymizationType.None;
        private static AnonymizationType    ___Anon__IPv4__Flags = AnonymizationType.None;
        private static AnonymizationType    ___Anon__IPv4__Fragment = AnonymizationType.None;
        private static AnonValueTransaction ___Anon__IPv4__Ttl = new AnonValueTransaction();
        private static AnonContentType      ___Anon__IPv4__Content = AnonContentType.Standard;

        private static string               ___Anon__IPv4__Local_ReplaceWith = "0.0.0.0";       // optional
        private static string               ___Anon__IPv4__Remote_ReplaceWith = "0.0.0.0";      // optional
        private static string               ___Anon__IPv4__Source_ReplaceWith = "0.0.0.0";      // optional
        private static string               ___Anon__IPv4__Destination_ReplaceWith = "0.0.0.0"; // optional
        private static byte                 ___Anon__IPv4__Tos_ReplaceWith = 0x00;              // optional
        private static int                  ___Anon__IPv4__Identification_ReplaceWith = 0x0000; // optional
        private static byte                 ___Anon__IPv4__Flags_ReplaceWith = 0x0;      //3 bit - optional
        private static byte                 ___Anon__IPv4__Fragment_ReplaceWith = 0x00; //13 bit - optional
        private static byte                 ___Anon__IPv4__Content_ReplaceWith = 0x00;          // optional

        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get General AnonType
        /// </summary>
        public AnonymizationType General
        {
            get
            {
                return ___Anon__IPv4__General;
            }
        }

        /// <summary>
        /// Get General Replacing
        /// </summary>
        public byte General_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__General_ReplaceWith;
            }
        }






        /// <summary>
        /// Get Local Address AnonType
        /// </summary>
        public AnonymizationType Local
        {
            get
            {
                return ___Anon__IPv4__Local;
            }
        }

        /// <summary>
        /// Get Local Address Masking
        /// </summary>
        public MaskIPv4Address Local_Mask
        {
            get
            {
                return ___Anon__IPv4__Local_Mask;
            }
        }

        /// <summary>
        /// Get Local Address Replacing
        /// </summary>
        public string Local_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Local_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Remote Address AnonType
        /// </summary>
        public AnonymizationType Remote
        {
            get
            {
                return ___Anon__IPv4__Remote;
            }
        }

        /// <summary>
        /// Get Remote Address Masking
        /// </summary>
        public MaskIPv4Address Remote_Mask
        {
            get
            {
                return ___Anon__IPv4__Remote_Mask;
            }
        }

        /// <summary>
        /// Get Remote Address Replacing
        /// </summary>
        public string Remote_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Remote_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Source Address AnonType
        /// </summary>
        public AnonymizationType Source
        {
            get
            {
                return ___Anon__IPv4__Source;
            }
        }

        /// <summary>
        /// Get Source Address Masking
        /// </summary>
        public MaskIPv4Address Source_Mask
        {
            get
            {
                return ___Anon__IPv4__Source_Mask;
            }
        }

        /// <summary>
        /// Get Source Address Replacing
        /// </summary>
        public string Source_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Source_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Destination Address AnonType
        /// </summary>
        public AnonymizationType Destination
        {
            get
            {
                return ___Anon__IPv4__Destination;
            }
        }

        /// <summary>
        /// Get Destination Address Masking
        /// </summary>
        public MaskIPv4Address Destination_Mask
        {
            get
            {
                return ___Anon__IPv4__Destination_Mask;
            }
        }

        /// <summary>
        /// Get Destination Address Replacing
        /// </summary>
        public string Destination_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Destination_ReplaceWith;
            }
        }




        /// <summary>
        /// Get TOS AnonType
        /// </summary>
        public AnonymizationType Tos
        {
            get
            {
                return ___Anon__IPv4__Tos;
            }
        }

        /// <summary>
        /// Get TOS Replacing
        /// </summary>
        public byte Tos_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Tos_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Identification AnonType
        /// </summary>
        public AnonymizationType Identification
        {
            get
            {
                return ___Anon__IPv4__Identification;
            }
        }

        /// <summary>
        /// Get Identifiation Replacing
        /// </summary>
        public int Identification_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Identification_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Flags AnonType
        /// </summary>
        public AnonymizationType Flags
        {
            get
            {
                return ___Anon__IPv4__Flags;
            }
        }

        /// <summary>
        /// Get Flags Replacing
        /// </summary>
        public byte Flags_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Flags_ReplaceWith;
            }
        }

        /// <summary>
        /// Get Fragment Offset AnonType
        /// </summary>
        public AnonymizationType FragmentOffset
        {
            get
            {
                return ___Anon__IPv4__Fragment;
            }
        }

        /// <summary>
        /// Get Fragment Offset Replacing
        /// </summary>
        public byte FragmentOffset_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Fragment_ReplaceWith;
            }
        }

        /// <summary>
        /// Get TTL AnonTransaction
        /// </summary>
        public AnonValueTransaction Ttl
        {
            get
            {
                return ___Anon__IPv4__Ttl;
            }
        }

        /// <summary>
        /// Get Content AnonType
        /// </summary>
        public AnonContentType Content
        {
            get
            {
                return ___Anon__IPv4__Content;
            }
        }

        /// <summary>
        /// Get Content Replacing
        /// </summary>
        public byte Content_ReplaceWith
        {
            get
            {
                return ___Anon__IPv4__Content_ReplaceWith;
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::



        /// <summary>
        /// Import Settings from XML Element
        /// </summary>
        /// <param name="element">input xml element</param>
        public void Import(XElement element)
        {
            
            if (element == null)
                return;

            IEnumerable<XElement> ipv4 = element.Elements("option");

            //
            //IPv4
            //
            #region IPv4
            {
                XElement src = null;
                XElement dst = null;
                XElement lcl = null;
                XElement rmt = null;
                XElement tos = null;
                XElement identifiation = null;
                XElement flags = null;
                XElement fo = null;
                XElement ttl = null;
                XElement content = null;
                foreach (var ipv4_item in ipv4)
                {
                    string name = (string)ipv4_item.Attribute("name");
                    if (name == "source-ip")
                        src = ipv4_item;
                    if (name == "destination-ip")
                        dst = ipv4_item;
                    if (name == "local-ip")
                        lcl = ipv4_item;
                    if (name == "remote-ip")
                        rmt = ipv4_item;
                    if (name == "tos")
                        tos = ipv4_item;
                    if (name == "identification")
                        identifiation = ipv4_item;
                    if (name == "flags")
                        flags = ipv4_item;
                    if (name == "fragment-offset")
                        fo = ipv4_item;
                    if (name == "ttl")
                        ttl = ipv4_item;
                    if (name == "content")
                        content = ipv4_item;
                }

                #region Source IP
                // Source IP
                if (src != null)
                {
                    string anon = (string)src.Attribute("anon");
                    string mask = (string)src.Attribute("mask");
                    string replace = (string)src.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Source = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Source = anonmapping;
                                    ___Anon__IPv4__Source_ReplaceWith = replace;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Source IP Replace Tag is missing");
                                }
                            }
                            if ((anonmapping != AnonymizationType.None) && (mask != null))
                            {
                                MaskIPv4Address masking = MaskIPv4Address.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 4)))
                                        ___Anon__IPv4__Source_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("IPv4 Source IP \"Mask length = 4\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("IPv4 Source IP - {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Source IP AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Destination IP
                // Destination IP
                if (dst != null)
                {
                    string anon = (string)dst.Attribute("anon");
                    string mask = (string)dst.Attribute("mask");
                    string replace = (string)dst.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Destination = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Destination = anonmapping;
                                    ___Anon__IPv4__Destination_ReplaceWith = replace;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Destination IP Replace Tag is missing");
                                }
                            }
                            if ((anonmapping != AnonymizationType.None) && (mask != null))
                            {
                                MaskIPv4Address masking = MaskIPv4Address.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 4)))
                                        ___Anon__IPv4__Destination_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("IPv4 Destination IP \"Mask length = 4\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("IPv4 Destination IP - {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Destination IP AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Local IP
                // Local IP
                if (lcl != null)
                {
                    string anon = (string)lcl.Attribute("anon");
                    string mask = (string)lcl.Attribute("mask");
                    string replace = (string)lcl.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Local = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Local = anonmapping;
                                    ___Anon__IPv4__Local_ReplaceWith = replace;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Local IP Replace Tag is missing");
                                }
                            }
                            if ((anonmapping != AnonymizationType.None) && (mask != null))
                            {
                                MaskIPv4Address masking = MaskIPv4Address.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 4)))
                                        ___Anon__IPv4__Local_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("IPv4 Local IP \"Mask length = 4\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("IPv4 Local IP - {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Local IP AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Remote IP
                // Remote IP
                if (rmt != null)
                {
                    string anon = (string)rmt.Attribute("anon");
                    string mask = (string)rmt.Attribute("mask");
                    string replace = (string)rmt.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Remote = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Remote = anonmapping;
                                    ___Anon__IPv4__Remote_ReplaceWith = replace;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Remote IP Replace Tag is missing");
                                }
                            }
                            if ((anonmapping != AnonymizationType.None) && (mask != null))
                            {
                                MaskIPv4Address masking = MaskIPv4Address.Parse(mask);
                                if (masking.IsCorrect)
                                {
                                    if ((masking.IsEmpty) || ((!masking.IsEmpty) && (masking.Length == 4)))
                                        ___Anon__IPv4__Remote_Mask = masking;
                                    else
                                        AppSettings.AddNewError(String.Format("IPv4 Remote IP \"Mask length = 4\" was expected"));
                                }
                                else
                                {
                                    AppSettings.AddNewError(String.Format("IPv4 Remote IP - {0}", masking.LastError));
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Remote IP AnonMapping has bad value");
                        }
                    }
                }
                #endregion



                #region TOS
                // TOS
                if (tos != null)
                {
                    string anon = (string)tos.Attribute("anon");
                    string replace = (string)tos.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Tos = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Tos = anonmapping;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__IPv4__Tos_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 TOS Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 TOS AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Identification
                // Identification
                if (identifiation != null)
                {
                    string anon = (string)identifiation.Attribute("anon");
                    string replace = (string)identifiation.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Identification = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Identification = anonmapping;
                                    int value;
                                    int.TryParse(replace, out value);
                                    ___Anon__IPv4__Identification_ReplaceWith = (int)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Identification Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Identification AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Flags
                // Flags
                if (flags != null)
                {
                    string anon = (string)flags.Attribute("anon");
                    string replace = (string)flags.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Flags = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Flags = anonmapping;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__IPv4__Flags_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Flags Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Flags AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region Fragment Offset
                // Fragment Offset
                if (fo != null)
                {
                    string anon = (string)fo.Attribute("anon");
                    string replace = (string)fo.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                            if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                            {
                                ___Anon__IPv4__Fragment = anonmapping;
                            }
                            else if (anonmapping == AnonymizationType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Fragment = anonmapping;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__IPv4__Fragment_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Fragment Offset Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Fragment Offset AnonMapping has bad value");
                        }
                    }
                }
                #endregion

                #region TTL
                // TTL
                if (ttl != null)
                {
                    string action = (string)ttl.Attribute("value-action");
                    AnonValueTransaction trans = new AnonValueTransaction(action);
                    if (trans.IsCorrect)
                    {
                        ___Anon__IPv4__Ttl = trans;
                    }
                    else
                    {
                        AppSettings.AddNewError(String.Format("IPv4 TTL {0}", trans.LastError));
                    }
                }
                #endregion

                #region Content
                // Content
                if (content != null)
                {
                    string anon = (string)content.Attribute("content-anon");
                    string replace = (string)content.Attribute("replace");
                    if (anon != null)
                    {
                        AnonContentType type;
                        if (anon.TryParse_AnonMappingValue(out type))
                        {
                            if ((type == AnonContentType.Dynamic) || (type == AnonContentType.Hash) || (type == AnonContentType.Standard))
                            {
                                ___Anon__IPv4__Content = type;
                            }
                            else if (type == AnonContentType.Static)
                            {
                                if (replace != null)
                                {
                                    ___Anon__IPv4__Content = type;
                                    byte value;
                                    byte.TryParse(replace, out value);
                                    ___Anon__IPv4__Content_ReplaceWith = (byte)value;
                                }
                                else
                                {
                                    AppSettings.AddNewError("IPv4 Content Replace Tag is missing");
                                }
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError("IPv4 Content AnonMapping has bad value");
                        }
                    }
                }
                #endregion

            }
            #endregion
        }



        /// <summary>
        /// Export Settings into XML Element
        /// </summary>
        /// <returns>output xml element</returns>
        public XElement Export()
        {
            XElement ipv4 = new XElement("protocol");
            ipv4.SetAttributeValue("name", "IPv4");
            if (template.IsEmpty)
                return ipv4;
            XElement ipSourceIP = new XElement("option");
            XElement ipDestinationIP = new XElement("option");
            XElement ipLocalIP = new XElement("option");
            XElement ipRemoteIP = new XElement("option");
            XElement ipTos = new XElement("option");
            XElement ipIdent = new XElement("option");
            XElement ipFlags = new XElement("option");
            XElement ipFragoffset = new XElement("option");
            XElement ipTtl = new XElement("option");
            XElement ipContent = new XElement("option");

            ipSourceIP.SetAttributeValue("name", "source-ip");
            ipDestinationIP.SetAttributeValue("name", "destination-ip");
            ipLocalIP.SetAttributeValue("name", "local-ip");
            ipRemoteIP.SetAttributeValue("name", "remote-ip");
            ipTos.SetAttributeValue("name", "tos");
            ipIdent.SetAttributeValue("name", "identification");
            ipFlags.SetAttributeValue("name", "flags");
            ipFragoffset.SetAttributeValue("name", "fragment-offset");
            ipTtl.SetAttributeValue("name", "ttl");
            ipContent.SetAttributeValue("name", "content");

            ipSourceIP.SetAttributeValue("anon", ___Anon__IPv4__Source.ConvertToString());
            ipDestinationIP.SetAttributeValue("anon", ___Anon__IPv4__Destination.ConvertToString());
            ipLocalIP.SetAttributeValue("anon", ___Anon__IPv4__Local.ConvertToString());
            ipRemoteIP.SetAttributeValue("anon", ___Anon__IPv4__Remote.ConvertToString());
            ipTos.SetAttributeValue("anon", ___Anon__IPv4__Tos.ConvertToString());
            ipIdent.SetAttributeValue("anon", ___Anon__IPv4__Identification.ConvertToString());
            ipFlags.SetAttributeValue("anon", ___Anon__IPv4__Flags.ConvertToString());
            ipFragoffset.SetAttributeValue("anon", ___Anon__IPv4__Fragment.ConvertToString());

            ipTtl.SetAttributeValue("value-action", ___Anon__IPv4__Ttl.Command);

            ipContent.SetAttributeValue("content-anon", ___Anon__IPv4__Content.ConvertToString());

            ipSourceIP.SetAttributeValue("mask", ___Anon__IPv4__Source_Mask.ToString());
            ipDestinationIP.SetAttributeValue("mask", ___Anon__IPv4__Destination_Mask.ToString());
            ipLocalIP.SetAttributeValue("mask", ___Anon__IPv4__Local_Mask.ToString());
            ipRemoteIP.SetAttributeValue("mask", ___Anon__IPv4__Remote_Mask.ToString());

            if (___Anon__IPv4__Source == AnonymizationType.Static)
                ipSourceIP.SetAttributeValue("replace", ___Anon__IPv4__Source_ReplaceWith);
            if (___Anon__IPv4__Destination == AnonymizationType.Static)
                ipDestinationIP.SetAttributeValue("replace", ___Anon__IPv4__Destination_ReplaceWith);
            if (___Anon__IPv4__Local == AnonymizationType.Static)
                ipLocalIP.SetAttributeValue("replace", ___Anon__IPv4__Local_ReplaceWith);
            if (___Anon__IPv4__Remote == AnonymizationType.Static)
                ipRemoteIP.SetAttributeValue("replace", ___Anon__IPv4__Remote_ReplaceWith);
            if (___Anon__IPv4__Tos == AnonymizationType.Static)
                ipTos.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__IPv4__Tos_ReplaceWith));
            if (___Anon__IPv4__Identification == AnonymizationType.Static)
                ipIdent.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__IPv4__Identification_ReplaceWith));
            if (___Anon__IPv4__Flags == AnonymizationType.Static)
                ipFlags.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__IPv4__Flags_ReplaceWith));
            if (___Anon__IPv4__Fragment == AnonymizationType.Static)
                ipFragoffset.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__IPv4__Fragment_ReplaceWith));
            if (___Anon__IPv4__General == AnonymizationType.Static)
                ipContent.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__IPv4__General_ReplaceWith));

            ipv4.Add(ipLocalIP);
            ipv4.Add(ipRemoteIP);
            ipv4.Add(ipSourceIP);
            ipv4.Add(ipDestinationIP);
            ipv4.Add(ipTos);
            ipv4.Add(ipIdent);
            ipv4.Add(ipFlags);
            ipv4.Add(ipFragoffset);
            ipv4.Add(ipTtl);
            ipv4.Add(ipContent);

            return ipv4;
        }



    }
}
