﻿//******************************************************************
// :: AnonValueTransaction Class - Anonmapping Value Transaction ::
//                                                      ver 2.00
//------------------------------------------------------------------
// XML Tag : "value-action" = 
//                            oper.func
//
// where oper = "" || "+" || "-",
//       func = number || RANDOM(l,r) || (RANDOM(l,x,r)
//       . = relate
//       number, l, r = ordinally numbers
//       x = global switch enabled
//******************************************************************
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace PacMap.Anonymize.Transactions
{
    /// <summary>
    /// Anonmapping Value Transaction Class
    /// </summary>
    public class AnonValueTransaction : AnonTransaction
    {

        /// <summary>
        /// Construct Empty Anonmapping Value Transaction
        /// </summary>
        public AnonValueTransaction()
            : base()
        {
        }

        /// <summary>
        /// Construct User Anonmapping Value Transaction
        /// </summary>
        /// <param name="phrase"></param>
        public AnonValueTransaction(string phrase)
            : base(phrase)
        {
            if (phrase == "none")
            {
                isCorrect = true;
                isEmpty = true;
                return;
            }
            isGlobal = true;


            bool isOk = false;
            bool isRandomized = false;
            int usernum = 0;
            Point userSpan = Point.Empty;
            string usertext = phrase;
            if (phrase != "")
            {
                string op = phrase.Substring(0, 1);
                if ((op == "+") || (op == "-"))
                {
                    if (phrase.Length > 1)
                        usertext = usertext.Substring(1, usertext.Length - 1);
                    else
                        usertext = "";
                }

                if (usertext.Length >= 9)
                {
                    string ran = usertext.Substring(0, 6);
                    if (ran == "RANDOM")
                    {
                        usertext = usertext.Substring(6, usertext.Length - 6);
                        string left = usertext.Substring(0, 1);
                        string right = usertext.Substring(usertext.Length - 1, 1);
                        if ((left == "(") && (right == ")"))
                        {
                            usertext = usertext.Substring(1, usertext.Length - 2);
                            string[] groups = usertext.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
                            if (groups.Count() == 1)
                            {
                                lastError = "Random Anonmappings - two values expected";
                            }
                            else if (groups.Count() == 2)
                            {
                                int l;
                                int r;
                                int.TryParse(groups[0], out l);
                                int.TryParse(groups[1], out r);
                                if (r >= l)
                                {
                                    userSpan = new Point(l, r);
                                    isRandomized = true;
                                    isGlobal = false;
                                    isOk = true;
                                }
                                else
                                    lastError = "Random Anonmappings - right value must be greater or equal left value of span";
                            }
                            else if (groups.Count() == 3)
                            {
                                if (groups[1].ToUpper() == "X")
                                {
                                    int l;
                                    int r;
                                    int.TryParse(groups[0], out l);
                                    int.TryParse(groups[2], out r);
                                    if (l <= r)
                                    {
                                        userSpan = new Point(l, r);
                                        isRandomized = true;
                                        isGlobal = true;
                                        isOk = true;
                                        // Get global number
                                        {
                                            Random randomizer = new Random();
                                            operatingValue = l + randomizer.Next(r - l);
                                        }
                                    }
                                    else
                                        lastError = "Random Anonmappings - right value must be greater or equal left value of span";
                                }
                            }
                            else
                                lastError = "Random Anonmappings - too many parameters";
                        }
                    }
                }

                if (!isRandomized)
                {
                    int.TryParse(usertext, out usernum);
                    userSpan = new Point(usernum, 0);
                    operatingValue = userSpan.X;
                    isRandomized = false;
                    isGlobal = true;
                    isOk = true;
                }

                if (isOk)
                {
                    if (usertext == "none")
                        type = AnonymizationType.None;
                    else if (!isRandomized)
                        type = AnonymizationType.Static;
                    else if (isRandomized)
                        type = AnonymizationType.Dynamic;

                    span = userSpan;
                    AnonValueType avalue = AnonValueType.None;
                    if (op == "+")
                        avalue = AnonValueType.Add;
                    if (op == "-")
                        avalue = AnonValueType.Sub;
                    valueType = avalue;

                    isCorrect = true;
                }
                else
                {
                    lastError = "Error Parsing Anonmappings string";
                }
            }
            else
            {
                lastError = "AnonMapping has empty format";
            }

        }


        /**********************************************************************************************/
        // :: DATA FIELDs ::
        private int operatingValue = 0;
        private Point span = Point.Empty;
        private AnonymizationType type = AnonymizationType.None;
        private AnonValueType valueType = AnonValueType.None;
        private int minValue = 0;
        private int maxValue = 65535;

        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get and mainly -SET- Min Value
        /// </summary>
        public int MinValue
        {
            get
            {
                return minValue;
            }
            set
            {
                minValue = value;
            }
        }


        /// <summary>
        /// Get and mainly -SET- Max Value
        /// </summary>
        public int MaxValue
        {
            get
            {
                return maxValue;
            }
            set
            {
                maxValue = value;
            }
        }
        #endregion

        /**********************************************************************************************/
        // :: GLOBAL METHODs ::

        /// <summary>
        /// Run Current Transaction on selected input item
        /// </summary>
        /// <param name="input">input number</param>
        /// <returns>output number</returns>
        public int Run(int input)
        {
            int result = 0;
            if (type == AnonymizationType.None)
                result = input;
            else if (type == AnonymizationType.Static)
            {
                if (valueType == AnonValueType.None)
                    result = operatingValue;
                else if (valueType == AnonValueType.Add)
                {
                    result += operatingValue;
                    if (result > maxValue)
                        result = maxValue;
                }
                else if (valueType == AnonValueType.Sub)
                {
                    result -= operatingValue;
                    if (result < minValue)
                        result = minValue;
                }
            }
            else if (type == AnonymizationType.Dynamic)
            {
                int operating = 0;
                if (isGlobal)
                    operating = operatingValue;
                else
                {
                    Random randomizer = new Random();
                    operating = span.X + randomizer.Next(span.Y - span.X);
                }

                if (valueType == AnonValueType.None)
                    result = operating;
                else if (valueType == AnonValueType.Add)
                {
                    result = input + operating;
                    if (result > maxValue)
                        result = maxValue;
                }
                else if (valueType == AnonValueType.Sub)
                {
                    result = input - operating;
                    if (result < minValue)
                        result = minValue;
                }
            }


            return result;
        }


        /// <summary>
        /// Convert To String
        /// </summary>
        /// <returns>string result</returns>
        public override string ToString()
        {
            return String.Format("AVT({0})", Command);
        }


    }
}
