﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using PacMap.General;
using System.IO;

namespace PacMap.Additionals.Exporting
{
    public class ArrowTable : Table
    {
        /// <summary>
        /// Constructs new empty table without lines
        /// </summary>
        public ArrowTable() : base()
        {
            titleColor = ConsoleColor.Gray;
            foreColor = ConsoleColor.DarkGray;
        }


        /***************************************************************************************************/
        // :: PRIVATE METHODs ::

        private void PrintOneLine(int index)
        {
            Console.CursorLeft = maxWidth - 1;
            Console.ForegroundColor = foreColor;
            if (index == 1)
            {
                Console.Write("▲\r▲");
            }
            else if (index == rows)
            {
                Console.Write("▼\r▼");
            }
            else
            {
                Console.Write("│\r│");
            }
        }

        /// <summary>
        /// Print table onto the STDOUT
        /// </summary>
        protected override void Print(TextWriter writer, bool isPrinting)
        {
            PrintInit(isPrinting);
            string defaultSeparator = "";
            if (isPrinting)
            {
                defaultSeparator = "│";
                PrintJustLine(writer, LineTypeEnum.Up);
            }



            PrintOneLine(writer, isPrinting, defaultSeparator, titles, true);
            NewLine(writer, isPrinting);

            if (isPrinting)
            {
                PrintJustLine(writer, LineTypeEnum.Middle);
            }

            #region Table Content
            for (int i = 1; i <= rows; i++)
            {
                IList<string> lineContent = new List<string>();
                foreach (var dataItem in data)
                {
                    IList<string> column = dataItem as IList<string>;
                    if (column != null)
                    {
                        lineContent.Add(column[i - 1]);
                    }
                }

                PrintOneLine(writer, isPrinting, defaultSeparator, lineContent, false);
                if (!isPrinting)
                    PrintOneLine(i);
                NewLine(writer, isPrinting);

            }
            #endregion


            if (isPrinting)
            {
                PrintJustLine(writer, LineTypeEnum.Down);
            }
        }

        /***************************************************************************************************/
        // :: PUBLIC METHODs ::

        

    }
}
