﻿//****************************\\
//*
//* :: ANONYMIZATOR ::
//*                    class
//----------------------------\\
//* ver 1.00
//****************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;

namespace PacMap.Anonymize
{
    public class Anonymizator
    {
        #region Constructors
        /// <summary>
        /// Create Default AnonMapper
        /// </summary>
        public Anonymizator()
        {

        }

        /// <summary>
        /// Create Advaced AnonMapper
        /// </summary>
        /// <param name="hashingKind">Hashing Type</param>
        /// <param name="operations">string describing operations (e.g.: "*8%40-6+90")</param>
        public Anonymizator(HashType hashingKind, string operations)
        {
            hashType = hashingKind;
            hashUserOptions = operations;
        }
        #endregion

        /******************************************************************************************/
        // :: DATA FIELDs ::
        private HashType hashType = AppSettings.HashingKind;
        private string hashUserOptions = AppSettings.HashingKindExtended;



        /******************************************************************************************/
        // :: GENERAL METHODs ::

        /// <summary>
        /// Anonymize item in packet
        /// </summary>
        /// <param name="input">item to anonmap</param>
        /// <param name="output">result of anonmapping</param>
        /// <param name="type">how to anonmap</param>
        /// <param name="replacingWith">replacing structure</param>
        /// <param name="tag">IPv4 | IPv6 | BYTE | WORD | DWORD | Unspecified</param>
        public void AnonMap(object input, out object output, AnonymizationType type, object replacingWith, object tag)
        {
            output = null;
            AnonimizatorInput target = AnonimizatorInput.Unspecified;
            {
                AnonimizatorInput? mytype = tag as AnonimizatorInput?;
                if (mytype != null)
                    target = (AnonimizatorInput)mytype;
            }

            


            //
            // None
            //
            if (type == AnonymizationType.None)
            {
                output = input;
            }




            
            //
            // Static AnonMapping
            //
            if (type == PacMap.Anonymize.AnonymizationType.Static)
            {
                output = replacingWith;

                if (target == AnonimizatorInput.Unspecified)
                {
                    byte[] inputArray = (byte[])input;
                    for (int i = 0; i < inputArray.Length; i++)
                    {
                        inputArray[i] = (byte)replacingWith;
                    }
                    output = inputArray;
                }
            }






            //
            // Dynamic AnonMapping
            //
            if (type == PacMap.Anonymize.AnonymizationType.Dynamic)
            {
                int bufferSize = 0;
                if (target == AnonimizatorInput.BYTE)
                    bufferSize = 1;
                if (target == AnonimizatorInput.WORD)
                    bufferSize = 2;
                if ((target == AnonimizatorInput.DWORD) || (target == AnonimizatorInput.IPv4))
                    bufferSize = 4;
                if (target == AnonimizatorInput.Unspecified)
                    bufferSize = ((tag as int?) ?? 0);


                Random randomizator = new Random(new Random().Next(255));
                byte[] dword = new byte[bufferSize];
                for (int i = 0; i <= bufferSize - 1; i++)
                {
                    dword[i] = (byte)randomizator.Next(255);
                }

                if (target == AnonimizatorInput.BYTE)
                    output = (int)dword[0];

                if (target == AnonimizatorInput.WORD)
                    output = (int)((dword[0] << 8) | (dword[1]));

                if (target == AnonimizatorInput.DWORD)
                    output = (uint)((dword[0] << 24) | (dword[1] << 16) | (dword[2] << 8) | (dword[3]));

                if (target == AnonimizatorInput.IPv4)
                    output = dword.ConvertIPv4ToString();

                if (target == AnonimizatorInput.Unspecified)
                    output = dword;
            }






            //
            // Hash AnonMapping
            //
            if (type == PacMap.Anonymize.AnonymizationType.Hash)
            {
                int bufferSize = 0;
                if (target == AnonimizatorInput.BYTE)
                    bufferSize = 1;
                if (target == AnonimizatorInput.WORD)
                    bufferSize = 2;
                if ((target == AnonimizatorInput.DWORD) || (target == AnonimizatorInput.IPv4))
                    bufferSize = 4;
                if (target == AnonimizatorInput.Unspecified)
                    bufferSize = ((tag as int?) ?? 0);

                byte[] dword = new byte[bufferSize];
                if (target == AnonimizatorInput.BYTE)
                    dword[0] = (byte)input;
                if (target == AnonimizatorInput.WORD)
                {
                    dword[0] = (byte)(((int)input & 0xFF00) >> 8);
                    dword[1] = (byte)((int)input & 0x00FF);
                }
                if (target == AnonimizatorInput.DWORD)
                {
                    dword[0] = (byte)(((int)input & 0xFF000000) >> 24);
                    dword[1] = (byte)(((int)input & 0x00FF0000) >> 16);
                    dword[2] = (byte)(((int)input & 0x0000FF00) >> 8);
                    dword[3] = (byte)((int)input & 0x000000FF);
                }
                if (target == AnonimizatorInput.Unspecified)
                {
                    dword = (byte[])input;
                }
                
                HashFunction hashF = new HashFunction(hashType, hashUserOptions);

                if ((target == AnonimizatorInput.BYTE) || (target == AnonimizatorInput.WORD) || (target == AnonimizatorInput.DWORD) || (target == AnonimizatorInput.Unspecified))
                {
                    dword = hashF.HashThis(dword);
                }


                if (target == AnonimizatorInput.BYTE)
                    output = (int)dword[0];

                if (target == AnonimizatorInput.WORD)
                    output = (int)((dword[0] << 8) | (dword[1]));

                if (target == AnonimizatorInput.DWORD)
                    output = (int)((dword[0] << 24) | (dword[1] << 16) | (dword[2] << 8) | (dword[3]));

                if (target == AnonimizatorInput.Unspecified)
                    output = dword;


                if (target == AnonimizatorInput.IPv4)
                {
                    string inputedString = input as string;
                    if (inputedString == null)
                        inputedString = "0.0.0.0"; // unexpected error
                    output = hashF.HashThis(inputedString.ConvertIPv4ToArray()).ConvertIPv4ToString();
                }
            }

            
        }
    }


    /// <summary>
    /// Anonymizator Function Input
    /// </summary>
    public enum AnonimizatorInput
    {
        IPv4,
        IPv6,
        BYTE,
        WORD,
        DWORD,
        Unspecified
    }
}
