﻿//********************************\\
//*
//*    (ANON-SETTINGS TEMPLATE)
//*                        HTTP
//*
//*                     ver 1.0
//********************************\\
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;
using PacMap.General.Masks;
using PacMap.Anonymize.Transactions;
using System.Xml.Linq;
using PacMap.Anonymize.HTTPRotator;

namespace PacMap.Anonymize.Templates.Items
{
    /// <summary>
    /// HTTP Anonmapping Information Template
    /// </summary>
    public class Temp__HTTP : Temp__base
    {

        /// <summary>
        /// Create Empty HTTP Anonmapping Information Template
        /// </summary>
        public Temp__HTTP(Template owner) : base(owner)
        {
            // following items are just examples, and should be deleted for final version
            //___Anon__HTTP__GET__Target = new AnonStringTransaction("REPLACE()");
            //___Anon__HTTP__GET__Host = new AnonStringTransaction("REPLACE()");
            //___Anon__HTTP__GET__Host_Mask = new MaskURI("none");
            //___Anon__HTTP__GET__TextRotator = new Rotator();
            //___Anon__HTTP__GET__TextRotator.Add(RotatorItem.Create("Connection:\"\"#keep-alive"));
            //___Anon__HTTP__GET__TextRotator.Add(RotatorItem.Create("User-Agent:''#!AST(REPLACE():13)"));
            //___Anon__HTTP__GET__TextRotator.Add(RotatorItem.Create("Referer:''#!AST(REPLACE(10,15)+'/'+GET(1,y)+'/'+GENERATE(123):3)"));
            //___Anon__HTTP__GET__TextRotator.Add(RotatorItem.Create("If-Modified-Since:''#!ADT(12.4.2013)"));

            //___Anon__HTTP__Date = new AnonDateTransaction("(1.2.2011;31.12.2011)");
            //___Anon__HTTP__Expires = new AnonDateTransaction("(1.1.2010 12:00; 4.12.2011 13:24)");
            //___Anon__HTTP__Cookies = new AnonStringTransaction("REPLACE(abc123!!)");
            //___Anon__HTTP__TextRotator = new Rotator();
            //___Anon__HTTP__TextRotator.Add(RotatorItem.Create("Content-Encoding:'gzip'#!AST(REPLACE(abc):6)"));
        }

        /**********************************************************************************************/
        // :: DATA FIELDs ::
        // ==HTTP======================================================================================

        private IDictionary<Protocols.HTTP.CommandsEnum, bool> containingRequests = new Dictionary<Protocols.HTTP.CommandsEnum, bool>()
        {
            {Protocols.HTTP.CommandsEnum.Get, true},
            {Protocols.HTTP.CommandsEnum.Connect, false},
            {Protocols.HTTP.CommandsEnum.Delete, false},
            {Protocols.HTTP.CommandsEnum.Head, false},
            {Protocols.HTTP.CommandsEnum.Options, false},
            {Protocols.HTTP.CommandsEnum.Post, false},
            {Protocols.HTTP.CommandsEnum.Put, false},
            {Protocols.HTTP.CommandsEnum.Trace, false},
        };

        //== GET ==
        private AnonStringTransaction ___Anon__HTTP__GET__Target = new AnonStringTransaction();
        private AnonStringTransaction ___Anon__HTTP__GET__Host = new AnonStringTransaction();
        private MaskURI               ___Anon__HTTP__GET__Host_Mask = new MaskURI();
        private AnonStringTransaction ___Anon__HTTP__GET__Cookies = new AnonStringTransaction();
        private Rotator               ___Anon__HTTP__GET__TextRotator = null;
        
        //<// other HTTP commands follow, can be implemented more anonmappings operations here in the future, now only rotators are implemented
        //== CONNECT ==
        private Rotator ___Anon__HTTP__CONNECT__TextRotator = null; // HINT : every rotator item can be generally overrided into any anonmapping transaction type

        //== DELETE ==
        private Rotator ___Anon__HTTP__DELETE__TextRotator = null;

        //== HEAD ==
        private Rotator ___Anon__HTTP__HEAD__TextRotator = null;

        //== OPTIONS ==
        private Rotator ___Anon__HTTP__OPTIONS__TextRotator = null;

        //== POST == 
        private Rotator ___Anon__HTTP__POST__TextRotator = null;

        //== PUT ==
        private Rotator ___Anon__HTTP__PUT__TextRotator = null;

        //== TRACE ==
        private Rotator ___Anon__HTTP__TRACE__TextRotator = null;
        //-- />

        //== HTTP ==
        private AnonDateTransaction   ___Anon__HTTP__Date = new AnonDateTransaction();
        private AnonDateTransaction   ___Anon__HTTP__Expires = new AnonDateTransaction();
        private AnonStringTransaction ___Anon__HTTP__Cookies = new AnonStringTransaction();
        private Rotator               ___Anon__HTTP__TextRotator = new Rotator();
        private AnonymizationType     ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported = AnonymizationType.None;
        private byte                  ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported_ReplaceWith = 0x00;


        

        /**********************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Get GET Target
        /// </summary>
        public AnonStringTransaction GET_Target
        {
            get
            {
                return ___Anon__HTTP__GET__Target;
            }
        }

        /// <summary>
        /// Get GET Host
        /// </summary>
        public AnonStringTransaction GET_Host
        {
            get
            {
                return ___Anon__HTTP__GET__Host;
            }
        }

        /// <summary>
        /// Get GET Host Masking
        /// </summary>
        public MaskURI GET_Host_Mask
        {
            get
            {
                return ___Anon__HTTP__GET__Host_Mask;
            }
        }

        /// <summary>
        /// Get GET Cookies
        /// </summary>
        public AnonStringTransaction GET_Cookies
        {
            get
            {
                return ___Anon__HTTP__GET__Cookies;
            }
        }

        /// <summary>
        /// Get GET Rotator
        /// </summary>
        public Rotator GET_Rotator
        {
            get
            {
                return ___Anon__HTTP__GET__TextRotator;
            }
        }

        /// <summary>
        /// Get CONNECT Rotator
        /// </summary>
        public Rotator CONNECT_Rotator
        {
            get
            {
                return ___Anon__HTTP__CONNECT__TextRotator;
            }
        }

        /// <summary>
        /// Get DELETE Rotator
        /// </summary>
        public Rotator DELETE_Rotator
        {
            get
            {
                return ___Anon__HTTP__DELETE__TextRotator;
            }
        }

        /// <summary>
        /// Get HEAD Rotator
        /// </summary>
        public Rotator HEAD_Rotator
        {
            get
            {
                return ___Anon__HTTP__HEAD__TextRotator;
            }
        }

        /// <summary>
        /// Get OPTIONS Rotator
        /// </summary>
        public Rotator OPTIONS_Rotator
        {
            get
            {
                return ___Anon__HTTP__OPTIONS__TextRotator;
            }
        }

        /// <summary>
        /// Get POST Rotator
        /// </summary>
        public Rotator POST_Rotator
        {
            get
            {
                return ___Anon__HTTP__POST__TextRotator;
            }
        }

        /// <summary>
        /// Get PUT Rotator
        /// </summary>
        public Rotator PUT_Rotator
        {
            get
            {
                return ___Anon__HTTP__PUT__TextRotator;
            }
        }

        /// <summary>
        /// Get TRACE Rotator
        /// </summary>
        public Rotator TRACE_Rotator
        {
            get
            {
                return ___Anon__HTTP__TRACE__TextRotator;
            }
        }

        /// <summary>
        /// Get HTTP Date
        /// </summary>
        public AnonDateTransaction HTTP_Date
        {
            get
            {
                return ___Anon__HTTP__Date;
            }
        }

        /// <summary>
        /// Get HTTP Expires
        /// </summary>
        public AnonDateTransaction HTTP_Expires
        {
            get
            {
                return ___Anon__HTTP__Expires;
            }
        }

        /// <summary>
        /// Get HTTP Cookies
        /// </summary>
        public AnonStringTransaction HTTP_Cookies
        {
            get
            {
                return ___Anon__HTTP__Cookies;
            }
        }

        /// <summary>
        /// Get HTTP Rotator
        /// </summary>
        public Rotator HTTP_Rotator
        {
            get
            {
                return ___Anon__HTTP__TextRotator;
            }
        }

        /// <summary>
        /// Get Data AnonType
        /// </summary>
        public AnonymizationType HTTP_Data
        {
            get
            {
                return ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported;
            }
        }

        /// <summary>
        /// Get Data Replacing
        /// </summary>
        public byte HTTP_Data_ReplaceWith
        {
            get
            {
                return ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported_ReplaceWith;
            }
        }
        #endregion


        /**********************************************************************************************/
        // :: FUNCTIONs ::
        /// <summary>
        /// to Clean class items for correct importing
        /// </summary>
        private void Clear()
        {
            containingRequests = new Dictionary<Protocols.HTTP.CommandsEnum, bool>()
            {
                {Protocols.HTTP.CommandsEnum.Get, false},
                {Protocols.HTTP.CommandsEnum.Connect, false},
                {Protocols.HTTP.CommandsEnum.Delete, false},
                {Protocols.HTTP.CommandsEnum.Head, false},
                {Protocols.HTTP.CommandsEnum.Options, false},
                {Protocols.HTTP.CommandsEnum.Post, false},
                {Protocols.HTTP.CommandsEnum.Put, false},
                {Protocols.HTTP.CommandsEnum.Trace, false},
            };

            ___Anon__HTTP__GET__Target = new AnonStringTransaction();
            ___Anon__HTTP__GET__Host = new AnonStringTransaction();
            ___Anon__HTTP__GET__Host_Mask = new MaskURI();
            ___Anon__HTTP__GET__Cookies = new AnonStringTransaction();

            ___Anon__HTTP__GET__TextRotator = null;
            ___Anon__HTTP__CONNECT__TextRotator = null;
            ___Anon__HTTP__DELETE__TextRotator = null;
            ___Anon__HTTP__HEAD__TextRotator = null;
            ___Anon__HTTP__OPTIONS__TextRotator = null;
            ___Anon__HTTP__POST__TextRotator = null;
            ___Anon__HTTP__PUT__TextRotator = null;
            ___Anon__HTTP__TRACE__TextRotator = null;

            ___Anon__HTTP__Date = new AnonDateTransaction();
            ___Anon__HTTP__Expires = new AnonDateTransaction();
            ___Anon__HTTP__Cookies = new AnonStringTransaction();
            ___Anon__HTTP__TextRotator = null;
            ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported = AnonymizationType.None;
            ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported_ReplaceWith = 0x00;
        }




        /**********************************************************************************************/
        // :: GLOBAL METHODs ::


        /// <summary>
        /// Import Settings from XML Element
        /// </summary>
        /// <param name="element">input xml element</param>
        public void Import(XElement element)
        {

            IEnumerable<XElement> requests = null;
            IEnumerable<XElement> response = null;
            foreach (var item in element.Elements("command"))
            {
                string name = (string)item.Attribute("name");
                if (name == "requests")
                    requests = item.Elements();
                if (name == "response")
                    response = item.Elements();
            }

            if ((requests == null) || (response == null))
            {
                AppSettings.AddNewError("HTTP Protocol - Request or Response field are missing");
                return;
            }
            Clear();

            #region REQUESTs
            //
            // :: REQUESTs ::
            //
            {
                XElement get = null;
                XElement connect = null;
                XElement delete = null;
                XElement head = null;
                XElement options = null;
                XElement post = null;
                XElement put = null;
                XElement trace = null;
                foreach (var item in requests)
                {
                    if (item.Name == "GET")
                    {
                        get = item;
                    }
                    if (item.Name == "CONNECT")
                    {
                        connect = item;
                    }
                    if (item.Name == "DELETE")
                    {
                        delete = item;
                    }
                    if (item.Name == "HEAD")
                    {
                        head = item;
                    }
                    if (item.Name == "OPTIONS")
                    {
                        options = item;
                    }
                    if (item.Name == "POST")
                    {
                        post = item;
                    }
                    if (item.Name == "PUT")
                    {
                        put = item;
                    }
                    if (item.Name == "TRACE")
                    {
                        trace = item;
                    }
                }


                #region GET
                //
                // GET
                //
                if (get != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Get] = true;
                    XElement target = null;
                    XElement host = null;
                    XElement cookies = null;
                    XElement rotator = null;
                    foreach (var item in get.Elements())
                    {
                        string name = (string)item.Attribute("name");
                        if ((item.Name == "option") && (name == "target"))
                            target = item;
                        if ((item.Name == "option") && (name == "host"))
                            host = item;
                        if ((item.Name == "option") && (name == "cookie"))
                            cookies = item;
                        if (item.Name == "rotator")
                            rotator = item;
                    }


                    string error = "HTTP Protocol - GET - option:";

                    // TARGET
                    if (target != null)
                    {
                        string action = (string)target.Attribute("string-action");
                        if (action != null)
                        {
                            AnonStringTransaction transaction = new AnonStringTransaction(action);
                            if (transaction.IsCorrect)
                                ___Anon__HTTP__GET__Target = transaction;
                            else
                            {
                                AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown transaction - {2}", error, (string)target.Attribute("name"), transaction.LastError));
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} \"{1}\" - \"string-action\" tag expected", error, (string)target.Attribute("name")));
                        }
                    }



                    // HOST
                    if (host != null)
                    {
                        string action = (string)host.Attribute("string-action");
                        string mask = (string)host.Attribute("mask");
                        if (action != null)
                        {
                            AnonStringTransaction transaction = new AnonStringTransaction(action);
                            if (transaction.IsCorrect)
                            {
                                ___Anon__HTTP__GET__Host = transaction;
                                if (mask != null)
                                {
                                    MaskURI masking = MaskURI.Parse(mask);
                                    if (masking.IsCorrect)
                                    {
                                        ___Anon__HTTP__GET__Host_Mask = masking;
                                    }
                                    else
                                    {
                                        AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown mask - {2}", error, (string)host.Attribute("name"), masking.LastError));
                                    }
                                }
                            }
                            else
                            {
                                AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown transaction - {2}", error, (string)host.Attribute("name"), transaction.LastError));
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} \"{1}\" - \"string-action\" tag expected", error, (string)host.Attribute("name")));
                        }
                    }




                    // COOKIEs
                    if (cookies != null)
                    {
                        string action = (string)cookies.Attribute("string-action");
                        if (action != null)
                        {
                            AnonStringTransaction transaction = new AnonStringTransaction(action);
                            if (transaction.IsCorrect)
                                ___Anon__HTTP__GET__Cookies = transaction;
                            else
                            {
                                AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown transaction - {2}", error, (string)target.Attribute("name"), transaction.LastError));
                            }
                        }
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} \"{1}\" - \"string-action\" tag expected", error, (string)target.Attribute("name")));
                        }
                    }



                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__GET__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }

                }
                #endregion

                #region CONNECT
                //
                // CONNECT
                //
                if (connect != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Connect] = true;
                    XElement rotator = null;
                    foreach (var item in connect.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - CONNECT - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__CONNECT__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

                #region DELETE
                //
                // DELETE
                //
                if (delete != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Delete] = true;
                    XElement rotator = null;
                    foreach (var item in delete.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - DELETE - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__DELETE__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

                #region HEAD
                //
                // HEAD
                //
                if (head != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Head] = true;
                    XElement rotator = null;
                    foreach (var item in head.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - HEAD - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__HEAD__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

                #region OPTIONS
                //
                // OPTIONS
                //
                if (options != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Options] = true;
                    XElement rotator = null;
                    foreach (var item in options.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - OPTIONS - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__OPTIONS__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

                #region POST
                //
                // POST
                //
                if (post != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Post] = true;
                    XElement rotator = null;
                    foreach (var item in post.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - POST - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__POST__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

                #region PUT
                //
                // PUT
                //
                if (put != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Put] = true;
                    XElement rotator = null;
                    foreach (var item in put.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - PUT - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__PUT__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

                #region TRACE
                //
                // TRACE
                //
                if (trace != null)
                {
                    containingRequests[Protocols.HTTP.CommandsEnum.Trace] = true;
                    XElement rotator = null;
                    foreach (var item in trace.Elements())
                    {
                        if (item.Name == "rotator")
                            rotator = item;
                    }
                    string error = "HTTP Protocol - TRACE - option:";

                    // ROTATOR
                    if (rotator != null)
                    {
                        Rotator newRotator = Rotator.Import(rotator);
                        if (newRotator.IsCorrect)
                            ___Anon__HTTP__TRACE__TextRotator = newRotator;
                        else
                        {
                            AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                        }
                    }
                }
                #endregion

            }
            #endregion

            #region RESPONSE
            //
            // :: RESPONSE ::
            //
            {
                XElement date = null;
                XElement expires = null;
                XElement setCookie = null;
                XElement rotator = null;
                XElement data = null;

                foreach (var item in response)
                {
                    string name = (string)item.Attribute("name");
                    if ((item.Name == "option") && (name == "date"))
                        date = item;
                    if ((item.Name == "option") && (name == "expires"))
                        expires = item;
                    if ((item.Name == "option") && (name == "set-cookie"))
                        setCookie = item;
                    if (item.Name == "rotator")
                        rotator = item;
                    if ((item.Name == "option") && (name == "data"))
                        data = item;
                }

                string error = "HTTP Protocol - option:";

                // DATE
                if (date != null)
                {
                    string action = (string)date.Attribute("date-action");
                    if (action != null)
                    {
                        AnonDateTransaction transaction = new AnonDateTransaction(action);
                        if (transaction.IsCorrect)
                            ___Anon__HTTP__Date = transaction;
                        else
                            AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown transaction - {2}", error, (string)date.Attribute("name"), transaction.LastError));
                    }
                    else
                    {
                        AppSettings.AddNewError(String.Format("{0} \"{1}\" - \"date-action\" tag expected", error, (string)date.Attribute("name")));
                    }
                }

                // EXPIRES
                if (expires != null)
                {
                    string action = (string)expires.Attribute("date-action");
                    if (action != null)
                    {
                        AnonDateTransaction transaction = new AnonDateTransaction(action);
                        if (transaction.IsCorrect)
                            ___Anon__HTTP__Expires = transaction;
                        else
                            AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown transaction - {2}", error, (string)expires.Attribute("name"), transaction.LastError));
                    }
                    else
                    {
                        AppSettings.AddNewError(String.Format("{0} \"{1}\" - \"date-action\" tag expected", error, (string)expires.Attribute("name")));
                    }
                }


                // SET COOKIE
                if (setCookie != null)
                {
                    string action = (string)setCookie.Attribute("string-action");
                    if (action != null)
                    {
                        AnonStringTransaction transaction = new AnonStringTransaction(action);
                        if (transaction.IsCorrect)
                            ___Anon__HTTP__Cookies = transaction;
                        else
                            AppSettings.AddNewError(String.Format("{0} \"{1}\" - bad or unknown transaction - {2}", error, (string)setCookie.Attribute("name"), transaction.LastError));
                    }
                    else
                    {
                        AppSettings.AddNewError(String.Format("{0} \"{1}\" - \"string-action\" tag expected", error, (string)setCookie.Attribute("name")));
                    }
                }


                // ROTATOR
                if (rotator != null)
                {
                    Rotator newRotator = Rotator.Import(rotator);
                    if (newRotator.IsCorrect)
                        ___Anon__HTTP__TextRotator = newRotator;
                    else
                    {
                        AppSettings.AddNewError(String.Format("{0} rotator - rotator is not in correct state - {1}", error, newRotator.LastError));
                    }
                }



                // DATA CONTENT
                if (data != null)
                {
                    string anon = (string)data.Attribute("anon");
                    string replace = (string)data.Attribute("replace");
                    AnonContentType type;
                    if (anon.TryParse_AnonMappingValue(out type))
                    {
                        AnonymizationType anonmapping = type.ConvertToAnonymizationType();
                        if ((anonmapping == AnonymizationType.Dynamic) || (anonmapping == AnonymizationType.Hash))
                        {
                            ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported = anonmapping;
                        }
                        else if (anonmapping == AnonymizationType.Static)
                        {
                            if (replace != null)
                            {
                                ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported = anonmapping;
                                byte value;
                                byte.TryParse(replace, out value);
                                ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported_ReplaceWith = (byte)value;
                            }
                            else
                            {
                                AppSettings.AddNewError("HTTP Protocol Replace Tag is missing");
                            }
                        }
                    }
                    else
                    {
                        AppSettings.AddNewError("HTTP Protocol AnonMapping has bad value");
                    }
                }

            }
            #endregion



        }



        /// <summary>
        /// Export Settings into XML Element
        /// </summary>
        /// <returns>output xml element</returns>
        public XElement Export()
        {
            XElement result = new XElement("protocol");
            result.SetAttributeValue("name", "HTTP");
            if (template.IsEmpty)
                return result;

            #region REQUESTS
            // == REQUESTS ==
            {
                XElement requests = new XElement("command");
                requests.SetAttributeValue("name", "requests");

                #region GET
                //
                // GET
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Get])
                {
                    XElement get = new XElement("GET");


                    XElement target = new XElement("option");
                    target.SetAttributeValue("name", "target");
                    target.SetAttributeValue("string-action", ___Anon__HTTP__GET__Target.Command);
                    get.Add(target);

                    XElement host = new XElement("option");
                    host.SetAttributeValue("name", "host");
                    host.SetAttributeValue("string-action", ___Anon__HTTP__GET__Host.Command);
                    host.SetAttributeValue("mask", ___Anon__HTTP__GET__Host_Mask.ToString());
                    get.Add(host);

                    XElement cookies = new XElement("option");
                    cookies.SetAttributeValue("name", "cookie");
                    cookies.SetAttributeValue("string-action", ___Anon__HTTP__GET__Cookies.Command);
                    get.Add(cookies);


                    if (___Anon__HTTP__GET__TextRotator != null)
                    {
                        get.Add(___Anon__HTTP__GET__TextRotator.Export());
                    }

                    requests.Add(get);
                }
                #endregion

                #region CONNECT
                //
                // CONNECT
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Connect])
                {
                    XElement connect = new XElement("CONNECT");

                    if (___Anon__HTTP__CONNECT__TextRotator != null)
                    {
                        connect.Add(___Anon__HTTP__CONNECT__TextRotator.Export());
                    }

                    requests.Add(connect);
                }
                #endregion

                #region DELETE
                //
                // DELETE
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Delete])
                {
                    XElement delete = new XElement("DELETE");

                    if (___Anon__HTTP__DELETE__TextRotator != null)
                    {
                        delete.Add(___Anon__HTTP__DELETE__TextRotator.Export());
                    }

                    requests.Add(delete);
                }
                #endregion

                #region HEAD
                //
                // HEAD
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Head])
                {
                    XElement head = new XElement("HEAD");

                    if (___Anon__HTTP__HEAD__TextRotator != null)
                    {
                        head.Add(___Anon__HTTP__HEAD__TextRotator.Export());
                    }

                    requests.Add(head);
                }
                #endregion

                #region OPTIONS
                //
                // OPTIONS
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Options])
                {
                    XElement options = new XElement("OPTIONS");

                    if (___Anon__HTTP__OPTIONS__TextRotator != null)
                    {
                        options.Add(___Anon__HTTP__OPTIONS__TextRotator.Export());
                    }

                    requests.Add(options);
                }
                #endregion

                #region POST
                //
                // POST
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Post])
                {
                    XElement post = new XElement("POST");

                    if (___Anon__HTTP__POST__TextRotator != null)
                    {
                        post.Add(___Anon__HTTP__POST__TextRotator.Export());
                    }

                    requests.Add(post);
                }
                #endregion

                #region PUT
                //
                // PUT
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Put])
                {
                    XElement put = new XElement("PUT");

                    if (___Anon__HTTP__PUT__TextRotator != null)
                    {
                        put.Add(___Anon__HTTP__PUT__TextRotator.Export());
                    }

                    requests.Add(put);
                }
                #endregion

                #region TRACE
                //
                // TRACE
                //
                if (containingRequests[Protocols.HTTP.CommandsEnum.Trace])
                {
                    XElement trace = new XElement("TRACE");

                    if (___Anon__HTTP__TRACE__TextRotator != null)
                    {
                        trace.Add(___Anon__HTTP__TRACE__TextRotator.Export());
                    }

                    requests.Add(trace);
                }
                #endregion

                result.Add(requests);
            }
            #endregion

            #region RESPONSE
            // == RESPONSE ==
            {
                XElement response = new XElement("command");
                response.SetAttributeValue("name", "response");

                XElement date = new XElement("option");
                date.SetAttributeValue("name", "date");
                date.SetAttributeValue("date-action", ___Anon__HTTP__Date.Command);
                response.Add(date);

                XElement expires = new XElement("option");
                expires.SetAttributeValue("name", "expires");
                expires.SetAttributeValue("date-action", ___Anon__HTTP__Expires.Command);
                response.Add(expires);

                XElement cookies = new XElement("option");
                cookies.SetAttributeValue("name", "set-cookie");
                cookies.SetAttributeValue("string-action", ___Anon__HTTP__Cookies.Command);
                response.Add(cookies);

                if (___Anon__HTTP__TextRotator != null)
                    response.Add(___Anon__HTTP__TextRotator.Export());

                XElement data = new XElement("option");
                data.SetAttributeValue("name", "data");
                data.SetAttributeValue("anon", ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported.ConvertToString());
                if (___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported == AnonymizationType.Static)
                    data.SetAttributeValue("replace", String.Format("0x{0:X}", ___Anon__HTTP__IfHasDataWhatAnonymizationIsSupported_ReplaceWith));
                response.Add(data);


                result.Add(response);
            }
            #endregion

            return result;
        }



    }
}
