﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacMap.General;
using PacMap.Anonymize;

namespace PacMap.Protocols
{
    public class Protocol
    {

        /// <summary>
        /// Create General Internet Protocol
        /// </summary>
        /// <param name="input"></param>
        public Protocol(byte[] input, Packet.Packet owner)
        {
            content = input;
            packet = owner;
            totalLngth = content.Length;
        }

        /*******************************************************************************************/
        // :: DATA FIELDs ::
        protected string mainInformation = "";
        protected string shortName = "";
        protected byte[] content = null;
        protected Protocol child = null;
        protected Packet.Packet packet = null;
        protected int totalLngth = 0;

        /*******************************************************************************************/
        // :: PROPERTIEs ::
        #region PROPERTIEs
        /// <summary>
        /// Ask if this contains some inner protocol
        /// </summary>
        public bool HasChild
        {
            get
            {
                if (child != null)
                    return true;
                else
                    return false;
            }
        }

        /// <summary>
        /// Get Child Content
        /// </summary>
        public Protocol Child
        {
            get
            {
                return child;
            }
        }

        /// <summary>
        /// Get Short Name Of Current Protocol
        /// </summary>
        public string Name
        {
            get
            {
                return shortName;
            }
        }

        /// <summary>
        /// Get Total Length of Protocol
        /// </summary>
        public int TotalLength
        {
            get
            {
                return totalLngth;
            }
        }
        #endregion





        /*******************************************************************************************/
        // :: GENERAL METHODs ::

        /// <summary>
        /// Export to byte[]
        /// </summary>
        /// <returns>bytes content</returns>
        public virtual byte[] Save()
        {
            return content;
        }

        /// <summary>
        /// Anonymize protocol
        /// </summary>
        public virtual void Anonymize()
        {
            Anonymizator anonymizator = new Anonymizator();

            object ___temp__content = null;
            anonymizator.AnonMap(content, out ___temp__content, packet.AnonSettings.General, packet.AnonSettings.General_ReplaceWith, content.Length);
            content = (byte[])___temp__content;
            
        }

        /// <summary>
        /// Get Full Packet Information for Advanced Packet Viewing
        /// </summary>
        /// <returns>NULL</returns>
        public virtual object GetFullInformation()
        {
            return null;
        }


        /// <summary>
        /// To String
        /// </summary>
        /// <returns>string result</returns>
        public override string ToString()
        {
            return String.Format("{0}", mainInformation.CleanColors());
        }
    }
}
