﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using PacMap.General;

namespace PacMap.Tracer
{
    /// <summary>
    /// Application Console Status Tracer
    /// </summary>
    public class ProgressTracer
    {



        private AppStatus lastState = AppStatus.Ready;
        private int lastPercentage = 0;
        private string text = "";


        private bool activated = false;
        private bool completed = false;

        private IDictionary<AppStatus, string> translateStatus = new Dictionary<AppStatus, string>()
        {
            {AppStatus.Ready, ""},
            {AppStatus.ReadingFile, "Reading file"},
            {AppStatus.SavingFile, "Saving file"},
            {AppStatus.Working, "Working"},
            {AppStatus.AnonMappings, "Making Anonmapping"},
        };



        /// <summary>
        /// Status Handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void Status(object sender, ProgressChangedEventArgs e)
        {

            AppStatus state = AppStatus.Ready;
            AppStatus? stateNull = e.UserState as AppStatus?;
            if (stateNull != null)
                state = (AppStatus)stateNull;

            if (state != lastState)
            {
                text = translateStatus[state];
                lastState = state;
            }


            if ((state != AppStatus.Ready) && (!activated) && (e.ProgressPercentage != 100))
            {
                Program.ProgressBar.NewOperation(text);
                activated = true;
                completed = false;
            }

            else if ((state != AppStatus.Ready) && (e.ProgressPercentage != lastPercentage) && (activated) && (e.ProgressPercentage != 100))
            {
                Program.ProgressBar.ShowProgressOperation(sender, e);
            }


            else if ((state != AppStatus.Ready) && (e.ProgressPercentage != lastPercentage) && (activated) && (e.ProgressPercentage == 100) && (!completed))
            {
                Program.ProgressBar.CompleteOperation();
                completed = true;
                activated = false;
            }

        }




    }
}
